/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.FieldValueUnion;
import software.amazon.awssdk.services.connect.model.SlaFieldValueUnionListCopier;
import software.amazon.awssdk.services.connect.model.SlaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaseSlaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaseSlaConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CaseSlaConfiguration.getter(CaseSlaConfiguration::name)).setter(CaseSlaConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CaseSlaConfiguration.getter(CaseSlaConfiguration::typeAsString)).setter(CaseSlaConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(CaseSlaConfiguration.getter(CaseSlaConfiguration::fieldId)).setter(CaseSlaConfiguration.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<List<FieldValueUnion>> TARGET_FIELD_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetFieldValues").getter(CaseSlaConfiguration.getter(CaseSlaConfiguration::targetFieldValues)).setter(CaseSlaConfiguration.setter(Builder::targetFieldValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFieldValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldValueUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TARGET_SLA_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TargetSlaMinutes").getter(CaseSlaConfiguration.getter(CaseSlaConfiguration::targetSlaMinutes)).setter(CaseSlaConfiguration.setter(Builder::targetSlaMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSlaMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, FIELD_ID_FIELD, TARGET_FIELD_VALUES_FIELD, TARGET_SLA_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaseSlaConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String fieldId;
    private final List<FieldValueUnion> targetFieldValues;
    private final Long targetSlaMinutes;

    private CaseSlaConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.fieldId = builder.fieldId;
        this.targetFieldValues = builder.targetFieldValues;
        this.targetSlaMinutes = builder.targetSlaMinutes;
    }

    public final String name() {
        return this.name;
    }

    public final SlaType type() {
        return SlaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final boolean hasTargetFieldValues() {
        return this.targetFieldValues != null && !(this.targetFieldValues instanceof SdkAutoConstructList);
    }

    public final List<FieldValueUnion> targetFieldValues() {
        return this.targetFieldValues;
    }

    public final Long targetSlaMinutes() {
        return this.targetSlaMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetFieldValues() ? this.targetFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSlaMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseSlaConfiguration)) {
            return false;
        }
        CaseSlaConfiguration other = (CaseSlaConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.fieldId(), other.fieldId()) && this.hasTargetFieldValues() == other.hasTargetFieldValues() && Objects.equals(this.targetFieldValues(), other.targetFieldValues()) && Objects.equals(this.targetSlaMinutes(), other.targetSlaMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"CaseSlaConfiguration").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("FieldId", (Object)this.fieldId()).add("TargetFieldValues", this.hasTargetFieldValues() ? this.targetFieldValues() : null).add("TargetSlaMinutes", (Object)this.targetSlaMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "TargetFieldValues": {
                return Optional.ofNullable(clazz.cast(this.targetFieldValues()));
            }
            case "TargetSlaMinutes": {
                return Optional.ofNullable(clazz.cast(this.targetSlaMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("TargetFieldValues", TARGET_FIELD_VALUES_FIELD);
        map.put("TargetSlaMinutes", TARGET_SLA_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseSlaConfiguration, T> g) {
        return obj -> g.apply((CaseSlaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String fieldId;
        private List<FieldValueUnion> targetFieldValues = DefaultSdkAutoConstructList.getInstance();
        private Long targetSlaMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseSlaConfiguration model) {
            this.name(model.name);
            this.type(model.type);
            this.fieldId(model.fieldId);
            this.targetFieldValues(model.targetFieldValues);
            this.targetSlaMinutes(model.targetSlaMinutes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SlaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<FieldValueUnion.Builder> getTargetFieldValues() {
            List<FieldValueUnion.Builder> result = SlaFieldValueUnionListCopier.copyToBuilder(this.targetFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetFieldValues(Collection<FieldValueUnion.BuilderImpl> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copyFromBuilder(targetFieldValues);
        }

        @Override
        public final Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copy(targetFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(FieldValueUnion ... targetFieldValues) {
            this.targetFieldValues(Arrays.asList(targetFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... targetFieldValues) {
            this.targetFieldValues(Stream.of(targetFieldValues).map(c -> (FieldValueUnion)((FieldValueUnion.Builder)FieldValueUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTargetSlaMinutes() {
            return this.targetSlaMinutes;
        }

        public final void setTargetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
        }

        @Override
        public final Builder targetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
            return this;
        }

        public CaseSlaConfiguration build() {
            return new CaseSlaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaseSlaConfiguration> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(SlaType var1);

        public Builder fieldId(String var1);

        public Builder targetFieldValues(Collection<FieldValueUnion> var1);

        public Builder targetFieldValues(FieldValueUnion ... var1);

        public Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... var1);

        public Builder targetSlaMinutes(Long var1);
    }
}

