/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowVersionSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsResponse;

public class ListContactFlowVersionsPublisher
implements SdkPublisher<ListContactFlowVersionsResponse> {
    private final ConnectAsyncClient client;
    private final ListContactFlowVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactFlowVersionsPublisher(ConnectAsyncClient client, ListContactFlowVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactFlowVersionsPublisher(ConnectAsyncClient client, ListContactFlowVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactFlowVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactFlowVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowVersionSummary> contactFlowVersionSummaryList() {
        Function<ListContactFlowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowVersionSummaryList() != null) {
                return response.contactFlowVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactFlowVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactFlowVersionsResponseFetcher
    implements AsyncPageFetcher<ListContactFlowVersionsResponse> {
        private ListContactFlowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactFlowVersionsResponse> nextPage(ListContactFlowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowVersionsPublisher.this.client.listContactFlowVersions(ListContactFlowVersionsPublisher.this.firstRequest);
            }
            return ListContactFlowVersionsPublisher.this.client.listContactFlowVersions((ListContactFlowVersionsRequest)((Object)ListContactFlowVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

