/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.IntegrationType;
import software.amazon.awssdk.services.connect.model.SourceType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationAssociationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateIntegrationAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::instanceId)).setter(CreateIntegrationAssociationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationType").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::integrationTypeAsString)).setter(CreateIntegrationAssociationRequest.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationArn").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::integrationArn)).setter(CreateIntegrationAssociationRequest.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()}).build();
    private static final SdkField<String> SOURCE_APPLICATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceApplicationUrl").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::sourceApplicationUrl)).setter(CreateIntegrationAssociationRequest.setter(Builder::sourceApplicationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationUrl").build()}).build();
    private static final SdkField<String> SOURCE_APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceApplicationName").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::sourceApplicationName)).setter(CreateIntegrationAssociationRequest.setter(Builder::sourceApplicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationName").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::sourceTypeAsString)).setter(CreateIntegrationAssociationRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateIntegrationAssociationRequest.getter(CreateIntegrationAssociationRequest::tags)).setter(CreateIntegrationAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_ARN_FIELD, SOURCE_APPLICATION_URL_FIELD, SOURCE_APPLICATION_NAME_FIELD, SOURCE_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIntegrationAssociationRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String integrationType;
    private final String integrationArn;
    private final String sourceApplicationUrl;
    private final String sourceApplicationName;
    private final String sourceType;
    private final Map<String, String> tags;

    private CreateIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.integrationType = builder.integrationType;
        this.integrationArn = builder.integrationArn;
        this.sourceApplicationUrl = builder.sourceApplicationUrl;
        this.sourceApplicationName = builder.sourceApplicationName;
        this.sourceType = builder.sourceType;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final String sourceApplicationUrl() {
        return this.sourceApplicationUrl;
    }

    public final String sourceApplicationName() {
        return this.sourceApplicationName;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApplicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationAssociationRequest)) {
            return false;
        }
        CreateIntegrationAssociationRequest other = (CreateIntegrationAssociationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.sourceApplicationUrl(), other.sourceApplicationUrl()) && Objects.equals(this.sourceApplicationName(), other.sourceApplicationName()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntegrationAssociationRequest").add("InstanceId", (Object)this.instanceId()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationArn", (Object)this.integrationArn()).add("SourceApplicationUrl", (Object)this.sourceApplicationUrl()).add("SourceApplicationName", (Object)this.sourceApplicationName()).add("SourceType", (Object)this.sourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IntegrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "IntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "SourceApplicationUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceApplicationUrl()));
            }
            case "SourceApplicationName": {
                return Optional.ofNullable(clazz.cast(this.sourceApplicationName()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("IntegrationType", INTEGRATION_TYPE_FIELD);
        map.put("IntegrationArn", INTEGRATION_ARN_FIELD);
        map.put("SourceApplicationUrl", SOURCE_APPLICATION_URL_FIELD);
        map.put("SourceApplicationName", SOURCE_APPLICATION_NAME_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String integrationType;
        private String integrationArn;
        private String sourceApplicationUrl;
        private String sourceApplicationName;
        private String sourceType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationAssociationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.integrationType(model.integrationType);
            this.integrationArn(model.integrationArn);
            this.sourceApplicationUrl(model.sourceApplicationUrl);
            this.sourceApplicationName(model.sourceApplicationName);
            this.sourceType(model.sourceType);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getSourceApplicationUrl() {
            return this.sourceApplicationUrl;
        }

        public final void setSourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
        }

        @Override
        public final Builder sourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
            return this;
        }

        public final String getSourceApplicationName() {
            return this.sourceApplicationName;
        }

        public final void setSourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
        }

        @Override
        public final Builder sourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationAssociationRequest build() {
            return new CreateIntegrationAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationAssociationRequest> {
        public Builder instanceId(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationArn(String var1);

        public Builder sourceApplicationUrl(String var1);

        public Builder sourceApplicationName(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

