/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.StringComparisonType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagSearchCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagSearchCondition> {
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagKey").getter(TagSearchCondition.getter(TagSearchCondition::tagKey)).setter(TagSearchCondition.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKey").build()}).build();
    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagValue").getter(TagSearchCondition.getter(TagSearchCondition::tagValue)).setter(TagSearchCondition.setter(Builder::tagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValue").build()}).build();
    private static final SdkField<String> TAG_KEY_COMPARISON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagKeyComparisonType").getter(TagSearchCondition.getter(TagSearchCondition::tagKeyComparisonTypeAsString)).setter(TagSearchCondition.setter(Builder::tagKeyComparisonType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyComparisonType").build()}).build();
    private static final SdkField<String> TAG_VALUE_COMPARISON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagValueComparisonType").getter(TagSearchCondition.getter(TagSearchCondition::tagValueComparisonTypeAsString)).setter(TagSearchCondition.setter(Builder::tagValueComparisonType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValueComparisonType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_KEY_FIELD, TAG_VALUE_FIELD, TAG_KEY_COMPARISON_TYPE_FIELD, TAG_VALUE_COMPARISON_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TagSearchCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tagKey;
    private final String tagValue;
    private final String tagKeyComparisonType;
    private final String tagValueComparisonType;

    private TagSearchCondition(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.tagKeyComparisonType = builder.tagKeyComparisonType;
        this.tagValueComparisonType = builder.tagValueComparisonType;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final String tagValue() {
        return this.tagValue;
    }

    public final StringComparisonType tagKeyComparisonType() {
        return StringComparisonType.fromValue(this.tagKeyComparisonType);
    }

    public final String tagKeyComparisonTypeAsString() {
        return this.tagKeyComparisonType;
    }

    public final StringComparisonType tagValueComparisonType() {
        return StringComparisonType.fromValue(this.tagValueComparisonType);
    }

    public final String tagValueComparisonTypeAsString() {
        return this.tagValueComparisonType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyComparisonTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValueComparisonTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagSearchCondition)) {
            return false;
        }
        TagSearchCondition other = (TagSearchCondition)obj;
        return Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.tagKeyComparisonTypeAsString(), other.tagKeyComparisonTypeAsString()) && Objects.equals(this.tagValueComparisonTypeAsString(), other.tagValueComparisonTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TagSearchCondition").add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("TagKeyComparisonType", (Object)this.tagKeyComparisonTypeAsString()).add("TagValueComparisonType", (Object)this.tagValueComparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "tagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "tagKeyComparisonType": {
                return Optional.ofNullable(clazz.cast(this.tagKeyComparisonTypeAsString()));
            }
            case "tagValueComparisonType": {
                return Optional.ofNullable(clazz.cast(this.tagValueComparisonTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tagKey", TAG_KEY_FIELD);
        map.put("tagValue", TAG_VALUE_FIELD);
        map.put("tagKeyComparisonType", TAG_KEY_COMPARISON_TYPE_FIELD);
        map.put("tagValueComparisonType", TAG_VALUE_COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagSearchCondition, T> g) {
        return obj -> g.apply((TagSearchCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tagKey;
        private String tagValue;
        private String tagKeyComparisonType;
        private String tagValueComparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(TagSearchCondition model) {
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.tagKeyComparisonType(model.tagKeyComparisonType);
            this.tagValueComparisonType(model.tagValueComparisonType);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getTagKeyComparisonType() {
            return this.tagKeyComparisonType;
        }

        public final void setTagKeyComparisonType(String tagKeyComparisonType) {
            this.tagKeyComparisonType = tagKeyComparisonType;
        }

        @Override
        public final Builder tagKeyComparisonType(String tagKeyComparisonType) {
            this.tagKeyComparisonType = tagKeyComparisonType;
            return this;
        }

        @Override
        public final Builder tagKeyComparisonType(StringComparisonType tagKeyComparisonType) {
            this.tagKeyComparisonType(tagKeyComparisonType == null ? null : tagKeyComparisonType.toString());
            return this;
        }

        public final String getTagValueComparisonType() {
            return this.tagValueComparisonType;
        }

        public final void setTagValueComparisonType(String tagValueComparisonType) {
            this.tagValueComparisonType = tagValueComparisonType;
        }

        @Override
        public final Builder tagValueComparisonType(String tagValueComparisonType) {
            this.tagValueComparisonType = tagValueComparisonType;
            return this;
        }

        @Override
        public final Builder tagValueComparisonType(StringComparisonType tagValueComparisonType) {
            this.tagValueComparisonType(tagValueComparisonType == null ? null : tagValueComparisonType.toString());
            return this;
        }

        public TagSearchCondition build() {
            return new TagSearchCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagSearchCondition> {
        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder tagKeyComparisonType(String var1);

        public Builder tagKeyComparisonType(StringComparisonType var1);

        public Builder tagValueComparisonType(String var1);

        public Builder tagValueComparisonType(StringComparisonType var1);
    }
}

