/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AgentStatus;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesResponse;

public class SearchAgentStatusesPublisher
implements SdkPublisher<SearchAgentStatusesResponse> {
    private final ConnectAsyncClient client;
    private final SearchAgentStatusesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAgentStatusesPublisher(ConnectAsyncClient client, SearchAgentStatusesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAgentStatusesPublisher(ConnectAsyncClient client, SearchAgentStatusesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAgentStatusesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAgentStatusesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentStatus> agentStatuses() {
        Function<SearchAgentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentStatuses() != null) {
                return response.agentStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchAgentStatusesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchAgentStatusesResponseFetcher
    implements AsyncPageFetcher<SearchAgentStatusesResponse> {
        private SearchAgentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(SearchAgentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAgentStatusesResponse> nextPage(SearchAgentStatusesResponse previousPage) {
            if (previousPage == null) {
                return SearchAgentStatusesPublisher.this.client.searchAgentStatuses(SearchAgentStatusesPublisher.this.firstRequest);
            }
            return SearchAgentStatusesPublisher.this.client.searchAgentStatuses((SearchAgentStatusesRequest)((Object)SearchAgentStatusesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

