/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEmailAddressResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, DescribeEmailAddressResponse> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressId").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::emailAddressId)).setter(DescribeEmailAddressResponse.setter(Builder::emailAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressId").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressArn").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::emailAddressArn)).setter(DescribeEmailAddressResponse.setter(Builder::emailAddressArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressArn").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::emailAddress)).setter(DescribeEmailAddressResponse.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::displayName)).setter(DescribeEmailAddressResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::description)).setter(DescribeEmailAddressResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateTimestamp").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::createTimestamp)).setter(DescribeEmailAddressResponse.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<String> MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModifiedTimestamp").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::modifiedTimestamp)).setter(DescribeEmailAddressResponse.setter(Builder::modifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeEmailAddressResponse.getter(DescribeEmailAddressResponse::tags)).setter(DescribeEmailAddressResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD, EMAIL_ADDRESS_ARN_FIELD, EMAIL_ADDRESS_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CREATE_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
            this.put("EmailAddressArn", EMAIL_ADDRESS_ARN_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
            this.put("ModifiedTimestamp", MODIFIED_TIMESTAMP_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String emailAddressId;
    private final String emailAddressArn;
    private final String emailAddress;
    private final String displayName;
    private final String description;
    private final String createTimestamp;
    private final String modifiedTimestamp;
    private final Map<String, String> tags;

    private DescribeEmailAddressResponse(BuilderImpl builder) {
        super(builder);
        this.emailAddressId = builder.emailAddressId;
        this.emailAddressArn = builder.emailAddressArn;
        this.emailAddress = builder.emailAddress;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.createTimestamp = builder.createTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.tags = builder.tags;
    }

    public final String emailAddressId() {
        return this.emailAddressId;
    }

    public final String emailAddressArn() {
        return this.emailAddressArn;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String createTimestamp() {
        return this.createTimestamp;
    }

    public final String modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEmailAddressResponse)) {
            return false;
        }
        DescribeEmailAddressResponse other = (DescribeEmailAddressResponse)((Object)obj);
        return Objects.equals(this.emailAddressId(), other.emailAddressId()) && Objects.equals(this.emailAddressArn(), other.emailAddressArn()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEmailAddressResponse").add("EmailAddressId", (Object)this.emailAddressId()).add("EmailAddressArn", (Object)this.emailAddressArn()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreateTimestamp", (Object)this.createTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddressId": {
                return Optional.ofNullable(clazz.cast(this.emailAddressId()));
            }
            case "EmailAddressArn": {
                return Optional.ofNullable(clazz.cast(this.emailAddressArn()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEmailAddressResponse, T> g) {
        return obj -> g.apply((DescribeEmailAddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String emailAddressId;
        private String emailAddressArn;
        private String emailAddress;
        private String displayName;
        private String description;
        private String createTimestamp;
        private String modifiedTimestamp;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEmailAddressResponse model) {
            super(model);
            this.emailAddressId(model.emailAddressId);
            this.emailAddressArn(model.emailAddressArn);
            this.emailAddress(model.emailAddress);
            this.displayName(model.displayName);
            this.description(model.description);
            this.createTimestamp(model.createTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.tags(model.tags);
        }

        public final String getEmailAddressId() {
            return this.emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getEmailAddressArn() {
            return this.emailAddressArn;
        }

        public final void setEmailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
        }

        @Override
        public final Builder emailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreateTimestamp() {
            return this.createTimestamp;
        }

        public final void setCreateTimestamp(String createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(String createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final String getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        public final void setModifiedTimestamp(String modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(String modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeEmailAddressResponse build() {
            return new DescribeEmailAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEmailAddressResponse> {
        public Builder emailAddressId(String var1);

        public Builder emailAddressArn(String var1);

        public Builder emailAddress(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder createTimestamp(String var1);

        public Builder modifiedTimestamp(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

