/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityProfileSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityProfileSearchSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::id)).setter(SecurityProfileSearchSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ORGANIZATION_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationResourceId").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::organizationResourceId)).setter(SecurityProfileSearchSummary.setter(Builder::organizationResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationResourceId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::arn)).setter(SecurityProfileSearchSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProfileName").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::securityProfileName)).setter(SecurityProfileSearchSummary.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::description)).setter(SecurityProfileSearchSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(SecurityProfileSearchSummary.getter(SecurityProfileSearchSummary::tags)).setter(SecurityProfileSearchSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ORGANIZATION_RESOURCE_ID_FIELD, ARN_FIELD, SECURITY_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("OrganizationResourceId", ORGANIZATION_RESOURCE_ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("SecurityProfileName", SECURITY_PROFILE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String organizationResourceId;
    private final String arn;
    private final String securityProfileName;
    private final String description;
    private final Map<String, String> tags;

    private SecurityProfileSearchSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.organizationResourceId = builder.organizationResourceId;
        this.arn = builder.arn;
        this.securityProfileName = builder.securityProfileName;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String organizationResourceId() {
        return this.organizationResourceId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String securityProfileName() {
        return this.securityProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileSearchSummary)) {
            return false;
        }
        SecurityProfileSearchSummary other = (SecurityProfileSearchSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.organizationResourceId(), other.organizationResourceId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityProfileSearchSummary").add("Id", (Object)this.id()).add("OrganizationResourceId", (Object)this.organizationResourceId()).add("Arn", (Object)this.arn()).add("SecurityProfileName", (Object)this.securityProfileName()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OrganizationResourceId": {
                return Optional.ofNullable(clazz.cast(this.organizationResourceId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SecurityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityProfileSearchSummary, T> g) {
        return obj -> g.apply((SecurityProfileSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String organizationResourceId;
        private String arn;
        private String securityProfileName;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileSearchSummary model) {
            this.id(model.id);
            this.organizationResourceId(model.organizationResourceId);
            this.arn(model.arn);
            this.securityProfileName(model.securityProfileName);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOrganizationResourceId() {
            return this.organizationResourceId;
        }

        public final void setOrganizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
        }

        @Override
        public final Builder organizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public SecurityProfileSearchSummary build() {
            return new SecurityProfileSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityProfileSearchSummary> {
        public Builder id(String var1);

        public Builder organizationResourceId(String var1);

        public Builder arn(String var1);

        public Builder securityProfileName(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

