/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.UserData;
import software.amazon.awssdk.services.connect.model.UserDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCurrentUserDataResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetCurrentUserDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCurrentUserDataResponse.getter(GetCurrentUserDataResponse::nextToken)).setter(GetCurrentUserDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<UserData>> USER_DATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserDataList").getter(GetCurrentUserDataResponse.getter(GetCurrentUserDataResponse::userDataList)).setter(GetCurrentUserDataResponse.setter(Builder::userDataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(GetCurrentUserDataResponse.getter(GetCurrentUserDataResponse::approximateTotalCount)).setter(GetCurrentUserDataResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, USER_DATA_LIST_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("UserDataList", USER_DATA_LIST_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final String nextToken;
    private final List<UserData> userDataList;
    private final Long approximateTotalCount;

    private GetCurrentUserDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userDataList = builder.userDataList;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUserDataList() {
        return this.userDataList != null && !(this.userDataList instanceof SdkAutoConstructList);
    }

    public final List<UserData> userDataList() {
        return this.userDataList;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDataList() ? this.userDataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentUserDataResponse)) {
            return false;
        }
        GetCurrentUserDataResponse other = (GetCurrentUserDataResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUserDataList() == other.hasUserDataList() && Objects.equals(this.userDataList(), other.userDataList()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetCurrentUserDataResponse").add("NextToken", (Object)this.nextToken()).add("UserDataList", this.hasUserDataList() ? this.userDataList() : null).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "UserDataList": {
                return Optional.ofNullable(clazz.cast(this.userDataList()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentUserDataResponse, T> g) {
        return obj -> g.apply((GetCurrentUserDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UserData> userDataList = DefaultSdkAutoConstructList.getInstance();
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentUserDataResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.userDataList(model.userDataList);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserData.Builder> getUserDataList() {
            List<UserData.Builder> result = UserDataListCopier.copyToBuilder(this.userDataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserDataList(Collection<UserData.BuilderImpl> userDataList) {
            this.userDataList = UserDataListCopier.copyFromBuilder(userDataList);
        }

        @Override
        public final Builder userDataList(Collection<UserData> userDataList) {
            this.userDataList = UserDataListCopier.copy(userDataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDataList(UserData ... userDataList) {
            this.userDataList(Arrays.asList(userDataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDataList(Consumer<UserData.Builder> ... userDataList) {
            this.userDataList(Stream.of(userDataList).map(c -> (UserData)((UserData.Builder)UserData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public GetCurrentUserDataResponse build() {
            return new GetCurrentUserDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCurrentUserDataResponse> {
        public Builder nextToken(String var1);

        public Builder userDataList(Collection<UserData> var1);

        public Builder userDataList(UserData ... var1);

        public Builder userDataList(Consumer<UserData.Builder> ... var1);

        public Builder approximateTotalCount(Long var1);
    }
}

