/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateParticipantRoleConfigChannelInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateParticipantRoleConfigChannelInfo> {
    private static final SdkField<ChatParticipantRoleConfig> CHAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Chat").getter(UpdateParticipantRoleConfigChannelInfo.getter(UpdateParticipantRoleConfigChannelInfo::chat)).setter(UpdateParticipantRoleConfigChannelInfo.setter(Builder::chat)).constructor(ChatParticipantRoleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Chat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ChatParticipantRoleConfig chat;
    private final Type type;

    private UpdateParticipantRoleConfigChannelInfo(BuilderImpl builder) {
        this.chat = builder.chat;
        this.type = builder.type;
    }

    public final ChatParticipantRoleConfig chat() {
        return this.chat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParticipantRoleConfigChannelInfo)) {
            return false;
        }
        UpdateParticipantRoleConfigChannelInfo other = (UpdateParticipantRoleConfigChannelInfo)obj;
        return Objects.equals(this.chat(), other.chat());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateParticipantRoleConfigChannelInfo").add("Chat", (Object)this.chat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Chat": {
                return Optional.ofNullable(clazz.cast(this.chat()));
            }
        }
        return Optional.empty();
    }

    public static UpdateParticipantRoleConfigChannelInfo fromChat(ChatParticipantRoleConfig chat) {
        return (UpdateParticipantRoleConfigChannelInfo)UpdateParticipantRoleConfigChannelInfo.builder().chat(chat).build();
    }

    public static UpdateParticipantRoleConfigChannelInfo fromChat(Consumer<ChatParticipantRoleConfig.Builder> chat) {
        ChatParticipantRoleConfig.Builder builder = ChatParticipantRoleConfig.builder();
        chat.accept(builder);
        return UpdateParticipantRoleConfigChannelInfo.fromChat((ChatParticipantRoleConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParticipantRoleConfigChannelInfo, T> g) {
        return obj -> g.apply((UpdateParticipantRoleConfigChannelInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CHAT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ChatParticipantRoleConfig chat;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParticipantRoleConfigChannelInfo model) {
            this.chat(model.chat);
        }

        public final ChatParticipantRoleConfig.Builder getChat() {
            return this.chat != null ? this.chat.toBuilder() : null;
        }

        public final void setChat(ChatParticipantRoleConfig.BuilderImpl chat) {
            ChatParticipantRoleConfig oldValue = this.chat;
            this.chat = chat != null ? chat.build() : null;
            this.handleUnionValueChange(Type.CHAT, oldValue, this.chat);
        }

        @Override
        public final Builder chat(ChatParticipantRoleConfig chat) {
            ChatParticipantRoleConfig oldValue = this.chat;
            this.chat = chat;
            this.handleUnionValueChange(Type.CHAT, oldValue, this.chat);
            return this;
        }

        public UpdateParticipantRoleConfigChannelInfo build() {
            return new UpdateParticipantRoleConfigChannelInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateParticipantRoleConfigChannelInfo> {
        public Builder chat(ChatParticipantRoleConfig var1);

        default public Builder chat(Consumer<ChatParticipantRoleConfig.Builder> chat) {
            return this.chat((ChatParticipantRoleConfig)((ChatParticipantRoleConfig.Builder)ChatParticipantRoleConfig.builder().applyMutation(chat)).build());
        }
    }
}

