/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;

public class ListApprovedOriginsIterable
implements SdkIterable<ListApprovedOriginsResponse> {
    private final ConnectClient client;
    private final ListApprovedOriginsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApprovedOriginsIterable(ConnectClient client, ListApprovedOriginsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApprovedOriginsResponseFetcher();
    }

    public Iterator<ListApprovedOriginsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> origins() {
        Function<ListApprovedOriginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.origins() != null) {
                return response.origins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApprovedOriginsResponseFetcher
    implements SyncPageFetcher<ListApprovedOriginsResponse> {
        private ListApprovedOriginsResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovedOriginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApprovedOriginsResponse nextPage(ListApprovedOriginsResponse previousPage) {
            if (previousPage == null) {
                return ListApprovedOriginsIterable.this.client.listApprovedOrigins(ListApprovedOriginsIterable.this.firstRequest);
            }
            return ListApprovedOriginsIterable.this.client.listApprovedOrigins((ListApprovedOriginsRequest)((Object)ListApprovedOriginsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

