/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.LexBot;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;

public class ListLexBotsPublisher
implements SdkPublisher<ListLexBotsResponse> {
    private final ConnectAsyncClient client;
    private final ListLexBotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLexBotsPublisher(ConnectAsyncClient client, ListLexBotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLexBotsPublisher(ConnectAsyncClient client, ListLexBotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLexBotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLexBotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LexBot> lexBots() {
        Function<ListLexBotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lexBots() != null) {
                return response.lexBots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLexBotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLexBotsResponseFetcher
    implements AsyncPageFetcher<ListLexBotsResponse> {
        private ListLexBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListLexBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLexBotsResponse> nextPage(ListLexBotsResponse previousPage) {
            if (previousPage == null) {
                return ListLexBotsPublisher.this.client.listLexBots(ListLexBotsPublisher.this.firstRequest);
            }
            return ListLexBotsPublisher.this.client.listLexBots((ListLexBotsRequest)((Object)ListLexBotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

