/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Request;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Response;

public class GetMetricDataV2Iterable
implements SdkIterable<GetMetricDataV2Response> {
    private final ConnectClient client;
    private final GetMetricDataV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMetricDataV2Iterable(ConnectClient client, GetMetricDataV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetMetricDataV2ResponseFetcher();
    }

    public Iterator<GetMetricDataV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetMetricDataV2ResponseFetcher
    implements SyncPageFetcher<GetMetricDataV2Response> {
        private GetMetricDataV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetMetricDataV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMetricDataV2Response nextPage(GetMetricDataV2Response previousPage) {
            if (previousPage == null) {
                return GetMetricDataV2Iterable.this.client.getMetricDataV2(GetMetricDataV2Iterable.this.firstRequest);
            }
            return GetMetricDataV2Iterable.this.client.getMetricDataV2((GetMetricDataV2Request)((Object)GetMetricDataV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

