/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListViewsRequest;
import software.amazon.awssdk.services.connect.model.ListViewsResponse;
import software.amazon.awssdk.services.connect.model.ViewSummary;

public class ListViewsIterable
implements SdkIterable<ListViewsResponse> {
    private final ConnectClient client;
    private final ListViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListViewsIterable(ConnectClient client, ListViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListViewsResponseFetcher();
    }

    public Iterator<ListViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ViewSummary> viewsSummaryList() {
        Function<ListViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.viewsSummaryList() != null) {
                return response.viewsSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListViewsResponseFetcher
    implements SyncPageFetcher<ListViewsResponse> {
        private ListViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListViewsResponse nextPage(ListViewsResponse previousPage) {
            if (previousPage == null) {
                return ListViewsIterable.this.client.listViews(ListViewsIterable.this.firstRequest);
            }
            return ListViewsIterable.this.client.listViews((ListViewsRequest)((Object)ListViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

