/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;

public class ListPhoneNumbersV2Iterable
implements SdkIterable<ListPhoneNumbersV2Response> {
    private final ConnectClient client;
    private final ListPhoneNumbersV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumbersV2Iterable(ConnectClient client, ListPhoneNumbersV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPhoneNumbersV2ResponseFetcher();
    }

    public Iterator<ListPhoneNumbersV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListPhoneNumbersSummary> listPhoneNumbersSummaryList() {
        Function<ListPhoneNumbersV2Response, Iterator> getIterator = response -> {
            if (response != null && response.listPhoneNumbersSummaryList() != null) {
                return response.listPhoneNumbersSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPhoneNumbersV2ResponseFetcher
    implements SyncPageFetcher<ListPhoneNumbersV2Response> {
        private ListPhoneNumbersV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumbersV2Response nextPage(ListPhoneNumbersV2Response previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersV2Iterable.this.client.listPhoneNumbersV2(ListPhoneNumbersV2Iterable.this.firstRequest);
            }
            return ListPhoneNumbersV2Iterable.this.client.listPhoneNumbersV2((ListPhoneNumbersV2Request)((Object)ListPhoneNumbersV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

