/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.HoursOfOperation;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse;

public class SearchHoursOfOperationsPublisher
implements SdkPublisher<SearchHoursOfOperationsResponse> {
    private final ConnectAsyncClient client;
    private final SearchHoursOfOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchHoursOfOperationsPublisher(ConnectAsyncClient client, SearchHoursOfOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchHoursOfOperationsPublisher(ConnectAsyncClient client, SearchHoursOfOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchHoursOfOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchHoursOfOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HoursOfOperation> hoursOfOperations() {
        Function<SearchHoursOfOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperations() != null) {
                return response.hoursOfOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchHoursOfOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchHoursOfOperationsResponseFetcher
    implements AsyncPageFetcher<SearchHoursOfOperationsResponse> {
        private SearchHoursOfOperationsResponseFetcher() {
        }

        public boolean hasNextPage(SearchHoursOfOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchHoursOfOperationsResponse> nextPage(SearchHoursOfOperationsResponse previousPage) {
            if (previousPage == null) {
                return SearchHoursOfOperationsPublisher.this.client.searchHoursOfOperations(SearchHoursOfOperationsPublisher.this.firstRequest);
            }
            return SearchHoursOfOperationsPublisher.this.client.searchHoursOfOperations((SearchHoursOfOperationsRequest)((Object)SearchHoursOfOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

