/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.EvaluationSummary;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse;

public class ListContactEvaluationsPublisher
implements SdkPublisher<ListContactEvaluationsResponse> {
    private final ConnectAsyncClient client;
    private final ListContactEvaluationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactEvaluationsPublisher(ConnectAsyncClient client, ListContactEvaluationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactEvaluationsPublisher(ConnectAsyncClient client, ListContactEvaluationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactEvaluationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactEvaluationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationSummary> evaluationSummaryList() {
        Function<ListContactEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationSummaryList() != null) {
                return response.evaluationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactEvaluationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactEvaluationsResponseFetcher
    implements AsyncPageFetcher<ListContactEvaluationsResponse> {
        private ListContactEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactEvaluationsResponse> nextPage(ListContactEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListContactEvaluationsPublisher.this.client.listContactEvaluations(ListContactEvaluationsPublisher.this.firstRequest);
            }
            return ListContactEvaluationsPublisher.this.client.listContactEvaluations((ListContactEvaluationsRequest)((Object)ListContactEvaluationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

