/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AllowedAccessControlTagsCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PermissionsListCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.TagRestrictedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecurityProfileRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProfileName").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::securityProfileName)).setter(CreateSecurityProfileRequest.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::description)).setter(CreateSecurityProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::permissions)).setter(CreateSecurityProfileRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::instanceId)).setter(CreateSecurityProfileRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::tags)).setter(CreateSecurityProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ALLOWED_ACCESS_CONTROL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AllowedAccessControlTags").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::allowedAccessControlTags)).setter(CreateSecurityProfileRequest.setter(Builder::allowedAccessControlTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_RESTRICTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagRestrictedResources").getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::tagRestrictedResources)).setter(CreateSecurityProfileRequest.setter(Builder::tagRestrictedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRestrictedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, PERMISSIONS_FIELD, INSTANCE_ID_FIELD, TAGS_FIELD, ALLOWED_ACCESS_CONTROL_TAGS_FIELD, TAG_RESTRICTED_RESOURCES_FIELD));
    private final String securityProfileName;
    private final String description;
    private final List<String> permissions;
    private final String instanceId;
    private final Map<String, String> tags;
    private final Map<String, String> allowedAccessControlTags;
    private final List<String> tagRestrictedResources;

    private CreateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.instanceId = builder.instanceId;
        this.tags = builder.tags;
        this.allowedAccessControlTags = builder.allowedAccessControlTags;
        this.tagRestrictedResources = builder.tagRestrictedResources;
    }

    public final String securityProfileName() {
        return this.securityProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasAllowedAccessControlTags() {
        return this.allowedAccessControlTags != null && !(this.allowedAccessControlTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> allowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public final boolean hasTagRestrictedResources() {
        return this.tagRestrictedResources != null && !(this.tagRestrictedResources instanceof SdkAutoConstructList);
    }

    public final List<String> tagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.description(), other.description()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAllowedAccessControlTags() == other.hasAllowedAccessControlTags() && Objects.equals(this.allowedAccessControlTags(), other.allowedAccessControlTags()) && this.hasTagRestrictedResources() == other.hasTagRestrictedResources() && Objects.equals(this.tagRestrictedResources(), other.tagRestrictedResources());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("Description", (Object)this.description()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("InstanceId", (Object)this.instanceId()).add("Tags", this.hasTags() ? this.tags() : null).add("AllowedAccessControlTags", this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null).add("TagRestrictedResources", this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AllowedAccessControlTags": {
                return Optional.ofNullable(clazz.cast(this.allowedAccessControlTags()));
            }
            case "TagRestrictedResources": {
                return Optional.ofNullable(clazz.cast(this.tagRestrictedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileRequest, T> g) {
        return obj -> g.apply((CreateSecurityProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String description;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> allowedAccessControlTags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> tagRestrictedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.description(model.description);
            this.permissions(model.permissions);
            this.instanceId(model.instanceId);
            this.tags(model.tags);
            this.allowedAccessControlTags(model.allowedAccessControlTags);
            this.tagRestrictedResources(model.tagRestrictedResources);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getAllowedAccessControlTags() {
            if (this.allowedAccessControlTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.allowedAccessControlTags;
        }

        public final void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
        }

        @Override
        public final Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
            return this;
        }

        public final Collection<String> getTagRestrictedResources() {
            if (this.tagRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagRestrictedResources;
        }

        public final void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
        }

        @Override
        public final Builder tagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRestrictedResources(String ... tagRestrictedResources) {
            this.tagRestrictedResources(Arrays.asList(tagRestrictedResources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityProfileRequest build() {
            return new CreateSecurityProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder description(String var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);

        public Builder instanceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder allowedAccessControlTags(Map<String, String> var1);

        public Builder tagRestrictedResources(Collection<String> var1);

        public Builder tagRestrictedResources(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

