/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventSourceName {
    ON_POST_CALL_ANALYSIS_AVAILABLE("OnPostCallAnalysisAvailable"),
    ON_REAL_TIME_CALL_ANALYSIS_AVAILABLE("OnRealTimeCallAnalysisAvailable"),
    ON_POST_CHAT_ANALYSIS_AVAILABLE("OnPostChatAnalysisAvailable"),
    ON_ZENDESK_TICKET_CREATE("OnZendeskTicketCreate"),
    ON_ZENDESK_TICKET_STATUS_UPDATE("OnZendeskTicketStatusUpdate"),
    ON_SALESFORCE_CASE_CREATE("OnSalesforceCaseCreate"),
    ON_CONTACT_EVALUATION_SUBMIT("OnContactEvaluationSubmit"),
    ON_METRIC_DATA_UPDATE("OnMetricDataUpdate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventSourceName> VALUE_MAP;
    private final String value;

    private EventSourceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventSourceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventSourceName> knownValues() {
        EnumSet<EventSourceName> knownValues = EnumSet.allOf(EventSourceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventSourceName.class, EventSourceName::toString);
    }
}

