/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary;

public class ListTrafficDistributionGroupUsersIterable
implements SdkIterable<ListTrafficDistributionGroupUsersResponse> {
    private final ConnectClient client;
    private final ListTrafficDistributionGroupUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrafficDistributionGroupUsersIterable(ConnectClient client, ListTrafficDistributionGroupUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrafficDistributionGroupUsersResponseFetcher();
    }

    public Iterator<ListTrafficDistributionGroupUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList() {
        Function<ListTrafficDistributionGroupUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficDistributionGroupUserSummaryList() != null) {
                return response.trafficDistributionGroupUserSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrafficDistributionGroupUsersResponseFetcher
    implements SyncPageFetcher<ListTrafficDistributionGroupUsersResponse> {
        private ListTrafficDistributionGroupUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficDistributionGroupUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrafficDistributionGroupUsersResponse nextPage(ListTrafficDistributionGroupUsersResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficDistributionGroupUsersIterable.this.client.listTrafficDistributionGroupUsers(ListTrafficDistributionGroupUsersIterable.this.firstRequest);
            }
            return ListTrafficDistributionGroupUsersIterable.this.client.listTrafficDistributionGroupUsers((ListTrafficDistributionGroupUsersRequest)((Object)ListTrafficDistributionGroupUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

