/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.InstanceReference;
import software.amazon.awssdk.services.connect.model.QueueReference;
import software.amazon.awssdk.services.connect.model.RoutingProfileReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dimensions> {
    private static final SdkField<QueueReference> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Queue").getter(Dimensions.getter(Dimensions::queue)).setter(Dimensions.setter(Builder::queue)).constructor(QueueReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(Dimensions.getter(Dimensions::channelAsString)).setter(Dimensions.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<RoutingProfileReference> ROUTING_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingProfile").getter(Dimensions.getter(Dimensions::routingProfile)).setter(Dimensions.setter(Builder::routingProfile)).constructor(RoutingProfileReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()}).build();
    private static final SdkField<InstanceReference> INSTANCE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceReference").getter(Dimensions.getter(Dimensions::instanceReference)).setter(Dimensions.setter(Builder::instanceReference)).constructor(InstanceReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD, CHANNEL_FIELD, ROUTING_PROFILE_FIELD, INSTANCE_REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final QueueReference queue;
    private final String channel;
    private final RoutingProfileReference routingProfile;
    private final InstanceReference instanceReference;

    private Dimensions(BuilderImpl builder) {
        this.queue = builder.queue;
        this.channel = builder.channel;
        this.routingProfile = builder.routingProfile;
        this.instanceReference = builder.instanceReference;
    }

    public final QueueReference queue() {
        return this.queue;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final RoutingProfileReference routingProfile() {
        return this.routingProfile;
    }

    public final InstanceReference instanceReference() {
        return this.instanceReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        return Objects.equals(this.queue(), other.queue()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.routingProfile(), other.routingProfile()) && Objects.equals(this.instanceReference(), other.instanceReference());
    }

    public final String toString() {
        return ToString.builder((String)"Dimensions").add("Queue", (Object)this.queue()).add("Channel", (Object)this.channelAsString()).add("RoutingProfile", (Object)this.routingProfile()).add("InstanceReference", (Object)this.instanceReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "RoutingProfile": {
                return Optional.ofNullable(clazz.cast(this.routingProfile()));
            }
            case "InstanceReference": {
                return Optional.ofNullable(clazz.cast(this.instanceReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Dimensions, T> g) {
        return obj -> g.apply((Dimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private QueueReference queue;
        private String channel;
        private RoutingProfileReference routingProfile;
        private InstanceReference instanceReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Dimensions model) {
            this.queue(model.queue);
            this.channel(model.channel);
            this.routingProfile(model.routingProfile);
            this.instanceReference(model.instanceReference);
        }

        public final QueueReference.Builder getQueue() {
            return this.queue != null ? this.queue.toBuilder() : null;
        }

        public final void setQueue(QueueReference.BuilderImpl queue) {
            this.queue = queue != null ? queue.build() : null;
        }

        @Override
        @Transient
        public final Builder queue(QueueReference queue) {
            this.queue = queue;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        @Transient
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        @Transient
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final RoutingProfileReference.Builder getRoutingProfile() {
            return this.routingProfile != null ? this.routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfileReference.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder routingProfile(RoutingProfileReference routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        public final InstanceReference.Builder getInstanceReference() {
            return this.instanceReference != null ? this.instanceReference.toBuilder() : null;
        }

        public final void setInstanceReference(InstanceReference.BuilderImpl instanceReference) {
            this.instanceReference = instanceReference != null ? instanceReference.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceReference(InstanceReference instanceReference) {
            this.instanceReference = instanceReference;
            return this;
        }

        public Dimensions build() {
            return new Dimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dimensions> {
        public Builder queue(QueueReference var1);

        default public Builder queue(Consumer<QueueReference.Builder> queue) {
            return this.queue((QueueReference)((QueueReference.Builder)QueueReference.builder().applyMutation(queue)).build());
        }

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder routingProfile(RoutingProfileReference var1);

        default public Builder routingProfile(Consumer<RoutingProfileReference.Builder> routingProfile) {
            return this.routingProfile((RoutingProfileReference)((RoutingProfileReference.Builder)RoutingProfileReference.builder().applyMutation(routingProfile)).build());
        }

        public Builder instanceReference(InstanceReference var1);

        default public Builder instanceReference(Consumer<InstanceReference.Builder> instanceReference) {
            return this.instanceReference((InstanceReference)((InstanceReference.Builder)InstanceReference.builder().applyMutation(instanceReference)).build());
        }
    }
}

