/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AgentContactReference;
import software.amazon.awssdk.services.connect.model.AgentContactReferenceListCopier;
import software.amazon.awssdk.services.connect.model.AgentStatusReference;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ChannelToCountMapCopier;
import software.amazon.awssdk.services.connect.model.HierarchyPathReference;
import software.amazon.awssdk.services.connect.model.RoutingProfileReference;
import software.amazon.awssdk.services.connect.model.UserReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserData> {
    private static final SdkField<UserReference> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("User").getter(UserData.getter(UserData::user)).setter(UserData.setter(Builder::user)).constructor(UserReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<RoutingProfileReference> ROUTING_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingProfile").getter(UserData.getter(UserData::routingProfile)).setter(UserData.setter(Builder::routingProfile)).constructor(RoutingProfileReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()}).build();
    private static final SdkField<HierarchyPathReference> HIERARCHY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HierarchyPath").getter(UserData.getter(UserData::hierarchyPath)).setter(UserData.setter(Builder::hierarchyPath)).constructor(HierarchyPathReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyPath").build()}).build();
    private static final SdkField<AgentStatusReference> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(UserData.getter(UserData::status)).setter(UserData.setter(Builder::status)).constructor(AgentStatusReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, Integer>> AVAILABLE_SLOTS_BY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AvailableSlotsByChannel").getter(UserData.getter(UserData::availableSlotsByChannelAsStrings)).setter(UserData.setter(Builder::availableSlotsByChannelWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSlotsByChannel").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> MAX_SLOTS_BY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MaxSlotsByChannel").getter(UserData.getter(UserData::maxSlotsByChannelAsStrings)).setter(UserData.setter(Builder::maxSlotsByChannelWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSlotsByChannel").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> ACTIVE_SLOTS_BY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ActiveSlotsByChannel").getter(UserData.getter(UserData::activeSlotsByChannelAsStrings)).setter(UserData.setter(Builder::activeSlotsByChannelWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSlotsByChannel").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AgentContactReference>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(UserData.getter(UserData::contacts)).setter(UserData.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentContactReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, ROUTING_PROFILE_FIELD, HIERARCHY_PATH_FIELD, STATUS_FIELD, AVAILABLE_SLOTS_BY_CHANNEL_FIELD, MAX_SLOTS_BY_CHANNEL_FIELD, ACTIVE_SLOTS_BY_CHANNEL_FIELD, CONTACTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final UserReference user;
    private final RoutingProfileReference routingProfile;
    private final HierarchyPathReference hierarchyPath;
    private final AgentStatusReference status;
    private final Map<String, Integer> availableSlotsByChannel;
    private final Map<String, Integer> maxSlotsByChannel;
    private final Map<String, Integer> activeSlotsByChannel;
    private final List<AgentContactReference> contacts;

    private UserData(BuilderImpl builder) {
        this.user = builder.user;
        this.routingProfile = builder.routingProfile;
        this.hierarchyPath = builder.hierarchyPath;
        this.status = builder.status;
        this.availableSlotsByChannel = builder.availableSlotsByChannel;
        this.maxSlotsByChannel = builder.maxSlotsByChannel;
        this.activeSlotsByChannel = builder.activeSlotsByChannel;
        this.contacts = builder.contacts;
    }

    public final UserReference user() {
        return this.user;
    }

    public final RoutingProfileReference routingProfile() {
        return this.routingProfile;
    }

    public final HierarchyPathReference hierarchyPath() {
        return this.hierarchyPath;
    }

    public final AgentStatusReference status() {
        return this.status;
    }

    public final Map<Channel, Integer> availableSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(this.availableSlotsByChannel);
    }

    public final boolean hasAvailableSlotsByChannel() {
        return this.availableSlotsByChannel != null && !(this.availableSlotsByChannel instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> availableSlotsByChannelAsStrings() {
        return this.availableSlotsByChannel;
    }

    public final Map<Channel, Integer> maxSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(this.maxSlotsByChannel);
    }

    public final boolean hasMaxSlotsByChannel() {
        return this.maxSlotsByChannel != null && !(this.maxSlotsByChannel instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> maxSlotsByChannelAsStrings() {
        return this.maxSlotsByChannel;
    }

    public final Map<Channel, Integer> activeSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(this.activeSlotsByChannel);
    }

    public final boolean hasActiveSlotsByChannel() {
        return this.activeSlotsByChannel != null && !(this.activeSlotsByChannel instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> activeSlotsByChannelAsStrings() {
        return this.activeSlotsByChannel;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<AgentContactReference> contacts() {
        return this.contacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableSlotsByChannel() ? this.availableSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaxSlotsByChannel() ? this.maxSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveSlotsByChannel() ? this.activeSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.routingProfile(), other.routingProfile()) && Objects.equals(this.hierarchyPath(), other.hierarchyPath()) && Objects.equals(this.status(), other.status()) && this.hasAvailableSlotsByChannel() == other.hasAvailableSlotsByChannel() && Objects.equals(this.availableSlotsByChannelAsStrings(), other.availableSlotsByChannelAsStrings()) && this.hasMaxSlotsByChannel() == other.hasMaxSlotsByChannel() && Objects.equals(this.maxSlotsByChannelAsStrings(), other.maxSlotsByChannelAsStrings()) && this.hasActiveSlotsByChannel() == other.hasActiveSlotsByChannel() && Objects.equals(this.activeSlotsByChannelAsStrings(), other.activeSlotsByChannelAsStrings()) && this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts());
    }

    public final String toString() {
        return ToString.builder((String)"UserData").add("User", (Object)this.user()).add("RoutingProfile", (Object)this.routingProfile()).add("HierarchyPath", (Object)this.hierarchyPath()).add("Status", (Object)this.status()).add("AvailableSlotsByChannel", this.hasAvailableSlotsByChannel() ? this.availableSlotsByChannelAsStrings() : null).add("MaxSlotsByChannel", this.hasMaxSlotsByChannel() ? this.maxSlotsByChannelAsStrings() : null).add("ActiveSlotsByChannel", this.hasActiveSlotsByChannel() ? this.activeSlotsByChannelAsStrings() : null).add("Contacts", this.hasContacts() ? this.contacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "RoutingProfile": {
                return Optional.ofNullable(clazz.cast(this.routingProfile()));
            }
            case "HierarchyPath": {
                return Optional.ofNullable(clazz.cast(this.hierarchyPath()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "AvailableSlotsByChannel": {
                return Optional.ofNullable(clazz.cast(this.availableSlotsByChannelAsStrings()));
            }
            case "MaxSlotsByChannel": {
                return Optional.ofNullable(clazz.cast(this.maxSlotsByChannelAsStrings()));
            }
            case "ActiveSlotsByChannel": {
                return Optional.ofNullable(clazz.cast(this.activeSlotsByChannelAsStrings()));
            }
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserData, T> g) {
        return obj -> g.apply((UserData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserReference user;
        private RoutingProfileReference routingProfile;
        private HierarchyPathReference hierarchyPath;
        private AgentStatusReference status;
        private Map<String, Integer> availableSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> maxSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> activeSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();
        private List<AgentContactReference> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            this.user(model.user);
            this.routingProfile(model.routingProfile);
            this.hierarchyPath(model.hierarchyPath);
            this.status(model.status);
            this.availableSlotsByChannelWithStrings(model.availableSlotsByChannel);
            this.maxSlotsByChannelWithStrings(model.maxSlotsByChannel);
            this.activeSlotsByChannelWithStrings(model.activeSlotsByChannel);
            this.contacts(model.contacts);
        }

        public final UserReference.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(UserReference.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(UserReference user) {
            this.user = user;
            return this;
        }

        public final RoutingProfileReference.Builder getRoutingProfile() {
            return this.routingProfile != null ? this.routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfileReference.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        public final Builder routingProfile(RoutingProfileReference routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        public final HierarchyPathReference.Builder getHierarchyPath() {
            return this.hierarchyPath != null ? this.hierarchyPath.toBuilder() : null;
        }

        public final void setHierarchyPath(HierarchyPathReference.BuilderImpl hierarchyPath) {
            this.hierarchyPath = hierarchyPath != null ? hierarchyPath.build() : null;
        }

        @Override
        public final Builder hierarchyPath(HierarchyPathReference hierarchyPath) {
            this.hierarchyPath = hierarchyPath;
            return this;
        }

        public final AgentStatusReference.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(AgentStatusReference.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AgentStatusReference status) {
            this.status = status;
            return this;
        }

        public final Map<String, Integer> getAvailableSlotsByChannel() {
            if (this.availableSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.availableSlotsByChannel;
        }

        public final void setAvailableSlotsByChannel(Map<String, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copy(availableSlotsByChannel);
        }

        @Override
        public final Builder availableSlotsByChannelWithStrings(Map<String, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copy(availableSlotsByChannel);
            return this;
        }

        @Override
        public final Builder availableSlotsByChannel(Map<Channel, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(availableSlotsByChannel);
            return this;
        }

        public final Map<String, Integer> getMaxSlotsByChannel() {
            if (this.maxSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.maxSlotsByChannel;
        }

        public final void setMaxSlotsByChannel(Map<String, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copy(maxSlotsByChannel);
        }

        @Override
        public final Builder maxSlotsByChannelWithStrings(Map<String, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copy(maxSlotsByChannel);
            return this;
        }

        @Override
        public final Builder maxSlotsByChannel(Map<Channel, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(maxSlotsByChannel);
            return this;
        }

        public final Map<String, Integer> getActiveSlotsByChannel() {
            if (this.activeSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.activeSlotsByChannel;
        }

        public final void setActiveSlotsByChannel(Map<String, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copy(activeSlotsByChannel);
        }

        @Override
        public final Builder activeSlotsByChannelWithStrings(Map<String, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copy(activeSlotsByChannel);
            return this;
        }

        @Override
        public final Builder activeSlotsByChannel(Map<Channel, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(activeSlotsByChannel);
            return this;
        }

        public final List<AgentContactReference.Builder> getContacts() {
            List<AgentContactReference.Builder> result = AgentContactReferenceListCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<AgentContactReference.BuilderImpl> contacts) {
            this.contacts = AgentContactReferenceListCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<AgentContactReference> contacts) {
            this.contacts = AgentContactReferenceListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(AgentContactReference ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<AgentContactReference.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (AgentContactReference)((AgentContactReference.Builder)AgentContactReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UserData build() {
            return new UserData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserData> {
        public Builder user(UserReference var1);

        default public Builder user(Consumer<UserReference.Builder> user) {
            return this.user((UserReference)((UserReference.Builder)UserReference.builder().applyMutation(user)).build());
        }

        public Builder routingProfile(RoutingProfileReference var1);

        default public Builder routingProfile(Consumer<RoutingProfileReference.Builder> routingProfile) {
            return this.routingProfile((RoutingProfileReference)((RoutingProfileReference.Builder)RoutingProfileReference.builder().applyMutation(routingProfile)).build());
        }

        public Builder hierarchyPath(HierarchyPathReference var1);

        default public Builder hierarchyPath(Consumer<HierarchyPathReference.Builder> hierarchyPath) {
            return this.hierarchyPath((HierarchyPathReference)((HierarchyPathReference.Builder)HierarchyPathReference.builder().applyMutation(hierarchyPath)).build());
        }

        public Builder status(AgentStatusReference var1);

        default public Builder status(Consumer<AgentStatusReference.Builder> status) {
            return this.status((AgentStatusReference)((AgentStatusReference.Builder)AgentStatusReference.builder().applyMutation(status)).build());
        }

        public Builder availableSlotsByChannelWithStrings(Map<String, Integer> var1);

        public Builder availableSlotsByChannel(Map<Channel, Integer> var1);

        public Builder maxSlotsByChannelWithStrings(Map<String, Integer> var1);

        public Builder maxSlotsByChannel(Map<Channel, Integer> var1);

        public Builder activeSlotsByChannelWithStrings(Map<String, Integer> var1);

        public Builder activeSlotsByChannel(Map<Channel, Integer> var1);

        public Builder contacts(Collection<AgentContactReference> var1);

        public Builder contacts(AgentContactReference ... var1);

        public Builder contacts(Consumer<AgentContactReference.Builder> ... var1);
    }
}

