/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.InstanceSummary;
import software.amazon.awssdk.services.connect.model.ListInstancesRequest;
import software.amazon.awssdk.services.connect.model.ListInstancesResponse;

public class ListInstancesPublisher
implements SdkPublisher<ListInstancesResponse> {
    private final ConnectAsyncClient client;
    private final ListInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstancesPublisher(ConnectAsyncClient client, ListInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstancesPublisher(ConnectAsyncClient client, ListInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceSummary> instanceSummaryList() {
        Function<ListInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceSummaryList() != null) {
                return response.instanceSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstancesResponseFetcher
    implements AsyncPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstancesResponse> nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesPublisher.this.client.listInstances(ListInstancesPublisher.this.firstRequest);
            }
            return ListInstancesPublisher.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

