/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.HierarchyGroupSummary;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;

public class ListUserHierarchyGroupsIterable
implements SdkIterable<ListUserHierarchyGroupsResponse> {
    private final ConnectClient client;
    private final ListUserHierarchyGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserHierarchyGroupsIterable(ConnectClient client, ListUserHierarchyGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUserHierarchyGroupsResponseFetcher();
    }

    public Iterator<ListUserHierarchyGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HierarchyGroupSummary> userHierarchyGroupSummaryList() {
        Function<ListUserHierarchyGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userHierarchyGroupSummaryList() != null) {
                return response.userHierarchyGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserHierarchyGroupsResponseFetcher
    implements SyncPageFetcher<ListUserHierarchyGroupsResponse> {
        private ListUserHierarchyGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserHierarchyGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserHierarchyGroupsResponse nextPage(ListUserHierarchyGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListUserHierarchyGroupsIterable.this.client.listUserHierarchyGroups(ListUserHierarchyGroupsIterable.this.firstRequest);
            }
            return ListUserHierarchyGroupsIterable.this.client.listUserHierarchyGroups((ListUserHierarchyGroupsRequest)((Object)ListUserHierarchyGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

