/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HistoricalMetricResult;
import software.amazon.awssdk.services.connect.model.HistoricalMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetMetricDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMetricDataResponse.getter(GetMetricDataResponse::nextToken)).setter(GetMetricDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<HistoricalMetricResult>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricResults").getter(GetMetricDataResponse.getter(GetMetricDataResponse::metricResults)).setter(GetMetricDataResponse.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistoricalMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, METRIC_RESULTS_FIELD));
    private final String nextToken;
    private final List<HistoricalMetricResult> metricResults;

    private GetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMetricResults() {
        return this.metricResults != null && !(this.metricResults instanceof SdkAutoConstructList);
    }

    public final List<HistoricalMetricResult> metricResults() {
        return this.metricResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricResults() ? this.metricResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataResponse)) {
            return false;
        }
        GetMetricDataResponse other = (GetMetricDataResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMetricResults() == other.hasMetricResults() && Objects.equals(this.metricResults(), other.metricResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricDataResponse").add("NextToken", (Object)this.nextToken()).add("MetricResults", this.hasMetricResults() ? this.metricResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataResponse, T> g) {
        return obj -> g.apply((GetMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HistoricalMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.metricResults(model.metricResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HistoricalMetricResult.Builder> getMetricResults() {
            List<HistoricalMetricResult.Builder> result = HistoricalMetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<HistoricalMetricResult.BuilderImpl> metricResults) {
            this.metricResults = HistoricalMetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        @Transient
        public final Builder metricResults(Collection<HistoricalMetricResult> metricResults) {
            this.metricResults = HistoricalMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricResults(HistoricalMetricResult ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricResults(Consumer<HistoricalMetricResult.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (HistoricalMetricResult)((HistoricalMetricResult.Builder)HistoricalMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMetricDataResponse build() {
            return new GetMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataResponse> {
        public Builder nextToken(String var1);

        public Builder metricResults(Collection<HistoricalMetricResult> var1);

        public Builder metricResults(HistoricalMetricResult ... var1);

        public Builder metricResults(Consumer<HistoricalMetricResult.Builder> ... var1);
    }
}

