/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Comparison;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Threshold
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Threshold> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comparison").getter(Threshold.getter(Threshold::comparisonAsString)).setter(Threshold.setter(Builder::comparison)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()}).build();
    private static final SdkField<Double> THRESHOLD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThresholdValue").getter(Threshold.getter(Threshold::thresholdValue)).setter(Threshold.setter(Builder::thresholdValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_FIELD, THRESHOLD_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparison;
    private final Double thresholdValue;

    private Threshold(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.thresholdValue = builder.thresholdValue;
    }

    public final Comparison comparison() {
        return Comparison.fromValue(this.comparison);
    }

    public final String comparisonAsString() {
        return this.comparison;
    }

    public final Double thresholdValue() {
        return this.thresholdValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threshold)) {
            return false;
        }
        Threshold other = (Threshold)obj;
        return Objects.equals(this.comparisonAsString(), other.comparisonAsString()) && Objects.equals(this.thresholdValue(), other.thresholdValue());
    }

    public final String toString() {
        return ToString.builder((String)"Threshold").add("Comparison", (Object)this.comparisonAsString()).add("ThresholdValue", (Object)this.thresholdValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comparison": {
                return Optional.ofNullable(clazz.cast(this.comparisonAsString()));
            }
            case "ThresholdValue": {
                return Optional.ofNullable(clazz.cast(this.thresholdValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Threshold, T> g) {
        return obj -> g.apply((Threshold)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparison;
        private Double thresholdValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Threshold model) {
            this.comparison(model.comparison);
            this.thresholdValue(model.thresholdValue);
        }

        public final String getComparison() {
            return this.comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        @Transient
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        @Transient
        public final Builder comparison(Comparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final Double getThresholdValue() {
            return this.thresholdValue;
        }

        public final void setThresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        @Override
        @Transient
        public final Builder thresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
            return this;
        }

        public Threshold build() {
            return new Threshold(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Threshold> {
        public Builder comparison(String var1);

        public Builder comparison(Comparison var1);

        public Builder thresholdValue(Double var1);
    }
}

