/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.LexBot;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;

public class ListLexBotsIterable
implements SdkIterable<ListLexBotsResponse> {
    private final ConnectClient client;
    private final ListLexBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLexBotsIterable(ConnectClient client, ListLexBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLexBotsResponseFetcher();
    }

    public Iterator<ListLexBotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LexBot> lexBots() {
        Function<ListLexBotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lexBots() != null) {
                return response.lexBots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLexBotsResponseFetcher
    implements SyncPageFetcher<ListLexBotsResponse> {
        private ListLexBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListLexBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLexBotsResponse nextPage(ListLexBotsResponse previousPage) {
            if (previousPage == null) {
                return ListLexBotsIterable.this.client.listLexBots(ListLexBotsIterable.this.firstRequest);
            }
            return ListLexBotsIterable.this.client.listLexBots((ListLexBotsRequest)((Object)ListLexBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

