/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityKeysResponse extends ConnectResponse implements
        ToCopyableBuilder<ListSecurityKeysResponse.Builder, ListSecurityKeysResponse> {
    private static final SdkField<List<SecurityKey>> SECURITY_KEYS_FIELD = SdkField
            .<List<SecurityKey>> builder(MarshallingType.LIST)
            .memberName("SecurityKeys")
            .getter(getter(ListSecurityKeysResponse::securityKeys))
            .setter(setter(Builder::securityKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSecurityKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_KEYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SecurityKey> securityKeys;

    private final String nextToken;

    private ListSecurityKeysResponse(BuilderImpl builder) {
        super(builder);
        this.securityKeys = builder.securityKeys;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SecurityKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecurityKeys() {
        return securityKeys != null && !(securityKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security keys.
     */
    public final List<SecurityKey> securityKeys() {
        return securityKeys;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityKeys() ? securityKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityKeysResponse)) {
            return false;
        }
        ListSecurityKeysResponse other = (ListSecurityKeysResponse) obj;
        return hasSecurityKeys() == other.hasSecurityKeys() && Objects.equals(securityKeys(), other.securityKeys())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityKeysResponse").add("SecurityKeys", hasSecurityKeys() ? securityKeys() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityKeys":
            return Optional.ofNullable(clazz.cast(securityKeys()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityKeysResponse, T> g) {
        return obj -> g.apply((ListSecurityKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityKeysResponse> {
        /**
         * <p>
         * The security keys.
         * </p>
         * 
         * @param securityKeys
         *        The security keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityKeys(Collection<SecurityKey> securityKeys);

        /**
         * <p>
         * The security keys.
         * </p>
         * 
         * @param securityKeys
         *        The security keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityKeys(SecurityKey... securityKeys);

        /**
         * <p>
         * The security keys.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityKey>.Builder} avoiding the need to
         * create one manually via {@link List<SecurityKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #securityKeys(List<SecurityKey>)}.
         * 
         * @param securityKeys
         *        a consumer that will call methods on {@link List<SecurityKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityKeys(List<SecurityKey>)
         */
        Builder securityKeys(Consumer<SecurityKey.Builder>... securityKeys);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<SecurityKey> securityKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityKeysResponse model) {
            super(model);
            securityKeys(model.securityKeys);
            nextToken(model.nextToken);
        }

        public final Collection<SecurityKey.Builder> getSecurityKeys() {
            if (securityKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return securityKeys != null ? securityKeys.stream().map(SecurityKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityKeys(Collection<SecurityKey> securityKeys) {
            this.securityKeys = SecurityKeysListCopier.copy(securityKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityKeys(SecurityKey... securityKeys) {
            securityKeys(Arrays.asList(securityKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityKeys(Consumer<SecurityKey.Builder>... securityKeys) {
            securityKeys(Stream.of(securityKeys).map(c -> SecurityKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityKeys(Collection<SecurityKey.BuilderImpl> securityKeys) {
            this.securityKeys = SecurityKeysListCopier.copyFromBuilder(securityKeys);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityKeysResponse build() {
            return new ListSecurityKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
