/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the historical metrics retrieved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoricalMetricResult implements SdkPojo, Serializable,
        ToCopyableBuilder<HistoricalMetricResult.Builder, HistoricalMetricResult> {
    private static final SdkField<Dimensions> DIMENSIONS_FIELD = SdkField.<Dimensions> builder(MarshallingType.SDK_POJO)
            .memberName("Dimensions").getter(getter(HistoricalMetricResult::dimensions)).setter(setter(Builder::dimensions))
            .constructor(Dimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<List<HistoricalMetricData>> COLLECTIONS_FIELD = SdkField
            .<List<HistoricalMetricData>> builder(MarshallingType.LIST)
            .memberName("Collections")
            .getter(getter(HistoricalMetricResult::collections))
            .setter(setter(Builder::collections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoricalMetricData> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoricalMetricData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            COLLECTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Dimensions dimensions;

    private final List<HistoricalMetricData> collections;

    private HistoricalMetricResult(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.collections = builder.collections;
    }

    /**
     * <p>
     * The dimension for the metrics.
     * </p>
     * 
     * @return The dimension for the metrics.
     */
    public final Dimensions dimensions() {
        return dimensions;
    }

    /**
     * Returns true if the Collections property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCollections() {
        return collections != null && !(collections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCollections()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The set of metrics.
     */
    public final List<HistoricalMetricData> collections() {
        return collections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollections() ? collections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetricResult)) {
            return false;
        }
        HistoricalMetricResult other = (HistoricalMetricResult) obj;
        return Objects.equals(dimensions(), other.dimensions()) && hasCollections() == other.hasCollections()
                && Objects.equals(collections(), other.collections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistoricalMetricResult").add("Dimensions", dimensions())
                .add("Collections", hasCollections() ? collections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Collections":
            return Optional.ofNullable(clazz.cast(collections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalMetricResult, T> g) {
        return obj -> g.apply((HistoricalMetricResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoricalMetricResult> {
        /**
         * <p>
         * The dimension for the metrics.
         * </p>
         * 
         * @param dimensions
         *        The dimension for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimensions dimensions);

        /**
         * <p>
         * The dimension for the metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link Dimensions.Builder} avoiding the need to create
         * one manually via {@link Dimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Dimensions.Builder#build()} is called immediately and its result
         * is passed to {@link #dimensions(Dimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link Dimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(Dimensions)
         */
        default Builder dimensions(Consumer<Dimensions.Builder> dimensions) {
            return dimensions(Dimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(Collection<HistoricalMetricData> collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * 
         * @param collections
         *        The set of metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collections(HistoricalMetricData... collections);

        /**
         * <p>
         * The set of metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistoricalMetricData>.Builder} avoiding the
         * need to create one manually via {@link List<HistoricalMetricData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoricalMetricData>.Builder#build()} is called immediately
         * and its result is passed to {@link #collections(List<HistoricalMetricData>)}.
         * 
         * @param collections
         *        a consumer that will call methods on {@link List<HistoricalMetricData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collections(List<HistoricalMetricData>)
         */
        Builder collections(Consumer<HistoricalMetricData.Builder>... collections);
    }

    static final class BuilderImpl implements Builder {
        private Dimensions dimensions;

        private List<HistoricalMetricData> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalMetricResult model) {
            dimensions(model.dimensions);
            collections(model.collections);
        }

        public final Dimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(Dimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final Collection<HistoricalMetricData.Builder> getCollections() {
            if (collections instanceof SdkAutoConstructList) {
                return null;
            }
            return collections != null ? collections.stream().map(HistoricalMetricData::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder collections(Collection<HistoricalMetricData> collections) {
            this.collections = HistoricalMetricDataCollectionsCopier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(HistoricalMetricData... collections) {
            collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<HistoricalMetricData.Builder>... collections) {
            collections(Stream.of(collections).map(c -> HistoricalMetricData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCollections(Collection<HistoricalMetricData.BuilderImpl> collections) {
            this.collections = HistoricalMetricDataCollectionsCopier.copyFromBuilder(collections);
        }

        @Override
        public HistoricalMetricResult build() {
            return new HistoricalMetricResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
