/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQuickConnectResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeQuickConnectResponse.Builder, DescribeQuickConnectResponse> {
    private static final SdkField<QuickConnect> QUICK_CONNECT_FIELD = SdkField.<QuickConnect> builder(MarshallingType.SDK_POJO)
            .memberName("QuickConnect").getter(getter(DescribeQuickConnectResponse::quickConnect))
            .setter(setter(Builder::quickConnect)).constructor(QuickConnect::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_FIELD));

    private final QuickConnect quickConnect;

    private DescribeQuickConnectResponse(BuilderImpl builder) {
        super(builder);
        this.quickConnect = builder.quickConnect;
    }

    /**
     * <p>
     * Information about the quick connect.
     * </p>
     * 
     * @return Information about the quick connect.
     */
    public final QuickConnect quickConnect() {
        return quickConnect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quickConnect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQuickConnectResponse)) {
            return false;
        }
        DescribeQuickConnectResponse other = (DescribeQuickConnectResponse) obj;
        return Objects.equals(quickConnect(), other.quickConnect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQuickConnectResponse").add("QuickConnect", quickConnect()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuickConnect":
            return Optional.ofNullable(clazz.cast(quickConnect()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQuickConnectResponse, T> g) {
        return obj -> g.apply((DescribeQuickConnectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeQuickConnectResponse> {
        /**
         * <p>
         * Information about the quick connect.
         * </p>
         * 
         * @param quickConnect
         *        Information about the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnect(QuickConnect quickConnect);

        /**
         * <p>
         * Information about the quick connect.
         * </p>
         * This is a convenience that creates an instance of the {@link QuickConnect.Builder} avoiding the need to
         * create one manually via {@link QuickConnect#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuickConnect.Builder#build()} is called immediately and its
         * result is passed to {@link #quickConnect(QuickConnect)}.
         * 
         * @param quickConnect
         *        a consumer that will call methods on {@link QuickConnect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickConnect(QuickConnect)
         */
        default Builder quickConnect(Consumer<QuickConnect.Builder> quickConnect) {
            return quickConnect(QuickConnect.builder().applyMutation(quickConnect).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private QuickConnect quickConnect;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQuickConnectResponse model) {
            super(model);
            quickConnect(model.quickConnect);
        }

        public final QuickConnect.Builder getQuickConnect() {
            return quickConnect != null ? quickConnect.toBuilder() : null;
        }

        @Override
        public final Builder quickConnect(QuickConnect quickConnect) {
            this.quickConnect = quickConnect;
            return this;
        }

        public final void setQuickConnect(QuickConnect.BuilderImpl quickConnect) {
            this.quickConnect = quickConnect != null ? quickConnect.build() : null;
        }

        @Override
        public DescribeQuickConnectResponse build() {
            return new DescribeQuickConnectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
