/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserHierarchyGroupRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateUserHierarchyGroupRequest.Builder, CreateUserHierarchyGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateUserHierarchyGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PARENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentGroupId").getter(getter(CreateUserHierarchyGroupRequest::parentGroupId))
            .setter(setter(Builder::parentGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentGroupId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateUserHierarchyGroupRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PARENT_GROUP_ID_FIELD, INSTANCE_ID_FIELD));

    private final String name;

    private final String parentGroupId;

    private final String instanceId;

    private CreateUserHierarchyGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.parentGroupId = builder.parentGroupId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The name of the user hierarchy group. Must not be more than 100 characters.
     * </p>
     * 
     * @return The name of the user hierarchy group. Must not be more than 100 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID
     * is null.
     * </p>
     * 
     * @return The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent
     *         group ID is null.
     */
    public final String parentGroupId() {
        return parentGroupId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parentGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserHierarchyGroupRequest)) {
            return false;
        }
        CreateUserHierarchyGroupRequest other = (CreateUserHierarchyGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(parentGroupId(), other.parentGroupId())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserHierarchyGroupRequest").add("Name", name()).add("ParentGroupId", parentGroupId())
                .add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParentGroupId":
            return Optional.ofNullable(clazz.cast(parentGroupId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserHierarchyGroupRequest, T> g) {
        return obj -> g.apply((CreateUserHierarchyGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserHierarchyGroupRequest> {
        /**
         * <p>
         * The name of the user hierarchy group. Must not be more than 100 characters.
         * </p>
         * 
         * @param name
         *        The name of the user hierarchy group. Must not be more than 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group
         * ID is null.
         * </p>
         * 
         * @param parentGroupId
         *        The identifier for the parent hierarchy group. The user hierarchy is created at level one if the
         *        parent group ID is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupId(String parentGroupId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String name;

        private String parentGroupId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserHierarchyGroupRequest model) {
            super(model);
            name(model.name);
            parentGroupId(model.parentGroupId);
            instanceId(model.instanceId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentGroupId() {
            return parentGroupId;
        }

        @Override
        public final Builder parentGroupId(String parentGroupId) {
            this.parentGroupId = parentGroupId;
            return this;
        }

        public final void setParentGroupId(String parentGroupId) {
            this.parentGroupId = parentGroupId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserHierarchyGroupRequest build() {
            return new CreateUserHierarchyGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
