/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuickConnectResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateQuickConnectResponse.Builder, CreateQuickConnectResponse> {
    private static final SdkField<String> QUICK_CONNECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectARN").getter(getter(CreateQuickConnectResponse::quickConnectARN))
            .setter(setter(Builder::quickConnectARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectARN").build()).build();

    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectId").getter(getter(CreateQuickConnectResponse::quickConnectId))
            .setter(setter(Builder::quickConnectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_ARN_FIELD,
            QUICK_CONNECT_ID_FIELD));

    private final String quickConnectARN;

    private final String quickConnectId;

    private CreateQuickConnectResponse(BuilderImpl builder) {
        super(builder);
        this.quickConnectARN = builder.quickConnectARN;
        this.quickConnectId = builder.quickConnectId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the quick connect.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the quick connect.
     */
    public final String quickConnectARN() {
        return quickConnectARN;
    }

    /**
     * <p>
     * The identifier for the quick connect.
     * </p>
     * 
     * @return The identifier for the quick connect.
     */
    public final String quickConnectId() {
        return quickConnectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectARN());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuickConnectResponse)) {
            return false;
        }
        CreateQuickConnectResponse other = (CreateQuickConnectResponse) obj;
        return Objects.equals(quickConnectARN(), other.quickConnectARN())
                && Objects.equals(quickConnectId(), other.quickConnectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuickConnectResponse").add("QuickConnectARN", quickConnectARN())
                .add("QuickConnectId", quickConnectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuickConnectARN":
            return Optional.ofNullable(clazz.cast(quickConnectARN()));
        case "QuickConnectId":
            return Optional.ofNullable(clazz.cast(quickConnectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuickConnectResponse, T> g) {
        return obj -> g.apply((CreateQuickConnectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateQuickConnectResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the quick connect.
         * </p>
         * 
         * @param quickConnectARN
         *        The Amazon Resource Name (ARN) for the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectARN(String quickConnectARN);

        /**
         * <p>
         * The identifier for the quick connect.
         * </p>
         * 
         * @param quickConnectId
         *        The identifier for the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectId(String quickConnectId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String quickConnectARN;

        private String quickConnectId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuickConnectResponse model) {
            super(model);
            quickConnectARN(model.quickConnectARN);
            quickConnectId(model.quickConnectId);
        }

        public final String getQuickConnectARN() {
            return quickConnectARN;
        }

        @Override
        public final Builder quickConnectARN(String quickConnectARN) {
            this.quickConnectARN = quickConnectARN;
            return this;
        }

        public final void setQuickConnectARN(String quickConnectARN) {
            this.quickConnectARN = quickConnectARN;
        }

        public final String getQuickConnectId() {
            return quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public CreateQuickConnectResponse build() {
            return new CreateQuickConnectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
