/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A toggle for an individual feature at the instance level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attribute implements SdkPojo, Serializable, ToCopyableBuilder<Attribute.Builder, Attribute> {
    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeType").getter(getter(Attribute::attributeTypeAsString)).setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Attribute::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_TYPE_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeType;

    private final String value;

    private Attribute(BuilderImpl builder) {
        this.attributeType = builder.attributeType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link InstanceAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The type of attribute.
     * @see InstanceAttributeType
     */
    public final InstanceAttributeType attributeType() {
        return InstanceAttributeType.fromValue(attributeType);
    }

    /**
     * <p>
     * The type of attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link InstanceAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The type of attribute.
     * @see InstanceAttributeType
     */
    public final String attributeTypeAsString() {
        return attributeType;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute) obj;
        return Objects.equals(attributeTypeAsString(), other.attributeTypeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attribute").add("AttributeType", attributeTypeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attribute> {
        /**
         * <p>
         * The type of attribute.
         * </p>
         * 
         * @param attributeType
         *        The type of attribute.
         * @see InstanceAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The type of attribute.
         * </p>
         * 
         * @param attributeType
         *        The type of attribute.
         * @see InstanceAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeType
         */
        Builder attributeType(InstanceAttributeType attributeType);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String attributeType;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            attributeType(model.attributeType);
            value(model.value);
        }

        public final String getAttributeType() {
            return attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(InstanceAttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Attribute build() {
            return new Attribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
