/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaConcurrency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaConcurrency> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(MediaConcurrency.getter(MediaConcurrency::channelAsString)).setter(MediaConcurrency.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<Integer> CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Concurrency").getter(MediaConcurrency.getter(MediaConcurrency::concurrency)).setter(MediaConcurrency.setter(Builder::concurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, CONCURRENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final Integer concurrency;

    private MediaConcurrency(BuilderImpl builder) {
        this.channel = builder.channel;
        this.concurrency = builder.concurrency;
    }

    public Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public String channelAsString() {
        return this.channel;
    }

    public Integer concurrency() {
        return this.concurrency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrency());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcurrency)) {
            return false;
        }
        MediaConcurrency other = (MediaConcurrency)obj;
        return Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.concurrency(), other.concurrency());
    }

    public String toString() {
        return ToString.builder((String)"MediaConcurrency").add("Channel", (Object)this.channelAsString()).add("Concurrency", (Object)this.concurrency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "Concurrency": {
                return Optional.ofNullable(clazz.cast(this.concurrency()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaConcurrency, T> g) {
        return obj -> g.apply((MediaConcurrency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channel;
        private Integer concurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConcurrency model) {
            this.channel(model.channel);
            this.concurrency(model.concurrency);
        }

        public final String getChannel() {
            return this.channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        public final Integer getConcurrency() {
            return this.concurrency;
        }

        @Override
        public final Builder concurrency(Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public final void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        public MediaConcurrency build() {
            return new MediaConcurrency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaConcurrency> {
        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder concurrency(Integer var1);
    }
}

