/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Channel {
    VOICE("VOICE"),
    CHAT("CHAT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Channel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Channel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Channel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Channel> knownValues() {
        return Stream.of(Channel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

