/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHoursOfOperationsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListHoursOfOperationsResponse.Builder, ListHoursOfOperationsResponse> {
    private static final SdkField<List<HoursOfOperationSummary>> HOURS_OF_OPERATION_SUMMARY_LIST_FIELD = SdkField
            .<List<HoursOfOperationSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListHoursOfOperationsResponse::hoursOfOperationSummaryList))
            .setter(setter(Builder::hoursOfOperationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HoursOfOperationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HoursOfOperationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHoursOfOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HOURS_OF_OPERATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<HoursOfOperationSummary> hoursOfOperationSummaryList;

    private final String nextToken;

    private ListHoursOfOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationSummaryList = builder.hoursOfOperationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HoursOfOperationSummaryList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasHoursOfOperationSummaryList() {
        return hoursOfOperationSummaryList != null && !(hoursOfOperationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the hours of operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHoursOfOperationSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the hours of operation.
     */
    public List<HoursOfOperationSummary> hoursOfOperationSummaryList() {
        return hoursOfOperationSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHoursOfOperationsResponse)) {
            return false;
        }
        ListHoursOfOperationsResponse other = (ListHoursOfOperationsResponse) obj;
        return Objects.equals(hoursOfOperationSummaryList(), other.hoursOfOperationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHoursOfOperationsResponse")
                .add("HoursOfOperationSummaryList", hoursOfOperationSummaryList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationSummaryList":
            return Optional.ofNullable(clazz.cast(hoursOfOperationSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHoursOfOperationsResponse, T> g) {
        return obj -> g.apply((ListHoursOfOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHoursOfOperationsResponse> {
        /**
         * <p>
         * Information about the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationSummaryList
         *        Information about the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationSummaryList(Collection<HoursOfOperationSummary> hoursOfOperationSummaryList);

        /**
         * <p>
         * Information about the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationSummaryList
         *        Information about the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationSummaryList(HoursOfOperationSummary... hoursOfOperationSummaryList);

        /**
         * <p>
         * Information about the hours of operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HoursOfOperationSummary>.Builder} avoiding
         * the need to create one manually via {@link List<HoursOfOperationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HoursOfOperationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #hoursOfOperationSummaryList(List<HoursOfOperationSummary>)}.
         * 
         * @param hoursOfOperationSummaryList
         *        a consumer that will call methods on {@link List<HoursOfOperationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hoursOfOperationSummaryList(List<HoursOfOperationSummary>)
         */
        Builder hoursOfOperationSummaryList(Consumer<HoursOfOperationSummary.Builder>... hoursOfOperationSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<HoursOfOperationSummary> hoursOfOperationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHoursOfOperationsResponse model) {
            super(model);
            hoursOfOperationSummaryList(model.hoursOfOperationSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<HoursOfOperationSummary.Builder> getHoursOfOperationSummaryList() {
            return hoursOfOperationSummaryList != null ? hoursOfOperationSummaryList.stream()
                    .map(HoursOfOperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hoursOfOperationSummaryList(Collection<HoursOfOperationSummary> hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList = HoursOfOperationSummaryListCopier.copy(hoursOfOperationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationSummaryList(HoursOfOperationSummary... hoursOfOperationSummaryList) {
            hoursOfOperationSummaryList(Arrays.asList(hoursOfOperationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationSummaryList(Consumer<HoursOfOperationSummary.Builder>... hoursOfOperationSummaryList) {
            hoursOfOperationSummaryList(Stream.of(hoursOfOperationSummaryList)
                    .map(c -> HoursOfOperationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHoursOfOperationSummaryList(
                Collection<HoursOfOperationSummary.BuilderImpl> hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList = HoursOfOperationSummaryListCopier.copyFromBuilder(hoursOfOperationSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHoursOfOperationsResponse build() {
            return new ListHoursOfOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
