/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.SecurityProfileIdsCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.UserIdentityInfo;
import software.amazon.awssdk.services.connect.model.UserPhoneConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::username)).setter(CreateUserRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::password)).setter(CreateUserRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateUserRequest.getter(CreateUserRequest::identityInfo)).setter(CreateUserRequest.setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()}).build();
    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateUserRequest.getter(CreateUserRequest::phoneConfig)).setter(CreateUserRequest.setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()}).build();
    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::directoryUserId)).setter(CreateUserRequest.setter(Builder::directoryUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()}).build();
    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateUserRequest.getter(CreateUserRequest::securityProfileIds)).setter(CreateUserRequest.setter(Builder::securityProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::routingProfileId)).setter(CreateUserRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::hierarchyGroupId)).setter(CreateUserRequest.setter(Builder::hierarchyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserRequest.getter(CreateUserRequest::instanceId)).setter(CreateUserRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateUserRequest.getter(CreateUserRequest::tags)).setter(CreateUserRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD, DIRECTORY_USER_ID_FIELD, SECURITY_PROFILE_IDS_FIELD, ROUTING_PROFILE_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, INSTANCE_ID_FIELD, TAGS_FIELD));
    private final String username;
    private final String password;
    private final UserIdentityInfo identityInfo;
    private final UserPhoneConfig phoneConfig;
    private final String directoryUserId;
    private final List<String> securityProfileIds;
    private final String routingProfileId;
    private final String hierarchyGroupId;
    private final String instanceId;
    private final Map<String, String> tags;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.password = builder.password;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.directoryUserId = builder.directoryUserId;
        this.securityProfileIds = builder.securityProfileIds;
        this.routingProfileId = builder.routingProfileId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.instanceId = builder.instanceId;
        this.tags = builder.tags;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public UserIdentityInfo identityInfo() {
        return this.identityInfo;
    }

    public UserPhoneConfig phoneConfig() {
        return this.phoneConfig;
    }

    public String directoryUserId() {
        return this.directoryUserId;
    }

    public List<String> securityProfileIds() {
        return this.securityProfileIds;
    }

    public String routingProfileId() {
        return this.routingProfileId;
    }

    public String hierarchyGroupId() {
        return this.hierarchyGroupId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.identityInfo(), other.identityInfo()) && Objects.equals(this.phoneConfig(), other.phoneConfig()) && Objects.equals(this.directoryUserId(), other.directoryUserId()) && Objects.equals(this.securityProfileIds(), other.securityProfileIds()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.hierarchyGroupId(), other.hierarchyGroupId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserRequest").add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("IdentityInfo", (Object)this.identityInfo()).add("PhoneConfig", (Object)this.phoneConfig()).add("DirectoryUserId", (Object)this.directoryUserId()).add("SecurityProfileIds", this.securityProfileIds()).add("RoutingProfileId", (Object)this.routingProfileId()).add("HierarchyGroupId", (Object)this.hierarchyGroupId()).add("InstanceId", (Object)this.instanceId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "IdentityInfo": {
                return Optional.ofNullable(clazz.cast(this.identityInfo()));
            }
            case "PhoneConfig": {
                return Optional.ofNullable(clazz.cast(this.phoneConfig()));
            }
            case "DirectoryUserId": {
                return Optional.ofNullable(clazz.cast(this.directoryUserId()));
            }
            case "SecurityProfileIds": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIds()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "HierarchyGroupId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private UserIdentityInfo identityInfo;
        private UserPhoneConfig phoneConfig;
        private String directoryUserId;
        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();
        private String routingProfileId;
        private String hierarchyGroupId;
        private String instanceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.username(model.username);
            this.password(model.password);
            this.identityInfo(model.identityInfo);
            this.phoneConfig(model.phoneConfig);
            this.directoryUserId(model.directoryUserId);
            this.securityProfileIds(model.securityProfileIds);
            this.routingProfileId(model.routingProfileId);
            this.hierarchyGroupId(model.hierarchyGroupId);
            this.instanceId(model.instanceId);
            this.tags(model.tags);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return this.identityInfo != null ? this.identityInfo.toBuilder() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return this.phoneConfig != null ? this.phoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        public final String getDirectoryUserId() {
            return this.directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        public final Collection<String> getSecurityProfileIds() {
            return this.securityProfileIds;
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String ... securityProfileIds) {
            this.securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final String getHierarchyGroupId() {
            return this.hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder identityInfo(UserIdentityInfo var1);

        default public Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return this.identityInfo((UserIdentityInfo)((UserIdentityInfo.Builder)UserIdentityInfo.builder().applyMutation(identityInfo)).build());
        }

        public Builder phoneConfig(UserPhoneConfig var1);

        default public Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return this.phoneConfig((UserPhoneConfig)((UserPhoneConfig.Builder)UserPhoneConfig.builder().applyMutation(phoneConfig)).build());
        }

        public Builder directoryUserId(String var1);

        public Builder securityProfileIds(Collection<String> var1);

        public Builder securityProfileIds(String ... var1);

        public Builder routingProfileId(String var1);

        public Builder hierarchyGroupId(String var1);

        public Builder instanceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

