/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo;
import software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryChannelStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryChannelStatus> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryChannelStatus.getter(DeliveryChannelStatus::name)).setter(DeliveryChannelStatus.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConfigExportDeliveryInfo> CONFIG_SNAPSHOT_DELIVERY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeliveryChannelStatus.getter(DeliveryChannelStatus::configSnapshotDeliveryInfo)).setter(DeliveryChannelStatus.setter(Builder::configSnapshotDeliveryInfo)).constructor(ConfigExportDeliveryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configSnapshotDeliveryInfo").build()}).build();
    private static final SdkField<ConfigExportDeliveryInfo> CONFIG_HISTORY_DELIVERY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeliveryChannelStatus.getter(DeliveryChannelStatus::configHistoryDeliveryInfo)).setter(DeliveryChannelStatus.setter(Builder::configHistoryDeliveryInfo)).constructor(ConfigExportDeliveryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configHistoryDeliveryInfo").build()}).build();
    private static final SdkField<ConfigStreamDeliveryInfo> CONFIG_STREAM_DELIVERY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeliveryChannelStatus.getter(DeliveryChannelStatus::configStreamDeliveryInfo)).setter(DeliveryChannelStatus.setter(Builder::configStreamDeliveryInfo)).constructor(ConfigStreamDeliveryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configStreamDeliveryInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIG_SNAPSHOT_DELIVERY_INFO_FIELD, CONFIG_HISTORY_DELIVERY_INFO_FIELD, CONFIG_STREAM_DELIVERY_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
    private final ConfigExportDeliveryInfo configHistoryDeliveryInfo;
    private final ConfigStreamDeliveryInfo configStreamDeliveryInfo;

    private DeliveryChannelStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.configSnapshotDeliveryInfo = builder.configSnapshotDeliveryInfo;
        this.configHistoryDeliveryInfo = builder.configHistoryDeliveryInfo;
        this.configStreamDeliveryInfo = builder.configStreamDeliveryInfo;
    }

    public String name() {
        return this.name;
    }

    public ConfigExportDeliveryInfo configSnapshotDeliveryInfo() {
        return this.configSnapshotDeliveryInfo;
    }

    public ConfigExportDeliveryInfo configHistoryDeliveryInfo() {
        return this.configHistoryDeliveryInfo;
    }

    public ConfigStreamDeliveryInfo configStreamDeliveryInfo() {
        return this.configStreamDeliveryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configSnapshotDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configHistoryDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configStreamDeliveryInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannelStatus)) {
            return false;
        }
        DeliveryChannelStatus other = (DeliveryChannelStatus)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configSnapshotDeliveryInfo(), other.configSnapshotDeliveryInfo()) && Objects.equals(this.configHistoryDeliveryInfo(), other.configHistoryDeliveryInfo()) && Objects.equals(this.configStreamDeliveryInfo(), other.configStreamDeliveryInfo());
    }

    public String toString() {
        return ToString.builder((String)"DeliveryChannelStatus").add("Name", (Object)this.name()).add("ConfigSnapshotDeliveryInfo", (Object)this.configSnapshotDeliveryInfo()).add("ConfigHistoryDeliveryInfo", (Object)this.configHistoryDeliveryInfo()).add("ConfigStreamDeliveryInfo", (Object)this.configStreamDeliveryInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configSnapshotDeliveryInfo": {
                return Optional.ofNullable(clazz.cast(this.configSnapshotDeliveryInfo()));
            }
            case "configHistoryDeliveryInfo": {
                return Optional.ofNullable(clazz.cast(this.configHistoryDeliveryInfo()));
            }
            case "configStreamDeliveryInfo": {
                return Optional.ofNullable(clazz.cast(this.configStreamDeliveryInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryChannelStatus, T> g) {
        return obj -> g.apply((DeliveryChannelStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ConfigExportDeliveryInfo configSnapshotDeliveryInfo;
        private ConfigExportDeliveryInfo configHistoryDeliveryInfo;
        private ConfigStreamDeliveryInfo configStreamDeliveryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannelStatus model) {
            this.name(model.name);
            this.configSnapshotDeliveryInfo(model.configSnapshotDeliveryInfo);
            this.configHistoryDeliveryInfo(model.configHistoryDeliveryInfo);
            this.configStreamDeliveryInfo(model.configStreamDeliveryInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigSnapshotDeliveryInfo() {
            return this.configSnapshotDeliveryInfo != null ? this.configSnapshotDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo;
            return this;
        }

        public final void setConfigSnapshotDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.build() : null;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigHistoryDeliveryInfo() {
            return this.configHistoryDeliveryInfo != null ? this.configHistoryDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo;
            return this;
        }

        public final void setConfigHistoryDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.build() : null;
        }

        public final ConfigStreamDeliveryInfo.Builder getConfigStreamDeliveryInfo() {
            return this.configStreamDeliveryInfo != null ? this.configStreamDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo;
            return this;
        }

        public final void setConfigStreamDeliveryInfo(ConfigStreamDeliveryInfo.BuilderImpl configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo != null ? configStreamDeliveryInfo.build() : null;
        }

        public DeliveryChannelStatus build() {
            return new DeliveryChannelStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryChannelStatus> {
        public Builder name(String var1);

        public Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo var1);

        default public Builder configSnapshotDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configSnapshotDeliveryInfo) {
            return this.configSnapshotDeliveryInfo((ConfigExportDeliveryInfo)((ConfigExportDeliveryInfo.Builder)ConfigExportDeliveryInfo.builder().applyMutation(configSnapshotDeliveryInfo)).build());
        }

        public Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo var1);

        default public Builder configHistoryDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configHistoryDeliveryInfo) {
            return this.configHistoryDeliveryInfo((ConfigExportDeliveryInfo)((ConfigExportDeliveryInfo.Builder)ConfigExportDeliveryInfo.builder().applyMutation(configHistoryDeliveryInfo)).build());
        }

        public Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo var1);

        default public Builder configStreamDeliveryInfo(Consumer<ConfigStreamDeliveryInfo.Builder> configStreamDeliveryInfo) {
            return this.configStreamDeliveryInfo((ConfigStreamDeliveryInfo)((ConfigStreamDeliveryInfo.Builder)ConfigStreamDeliveryInfo.builder().applyMutation(configStreamDeliveryInfo)).build());
        }
    }
}

