/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with the name of the retention configuration and the retention period in days. The object stores the
 * configuration for data retention in Config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionConfiguration.Builder, RetentionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RetentionConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriodInDays").getter(getter(RetentionConfiguration::retentionPeriodInDays))
            .setter(setter(Builder::retentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RETENTION_PERIOD_IN_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer retentionPeriodInDays;

    private RetentionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    /**
     * <p>
     * The name of the retention configuration object.
     * </p>
     * 
     * @return The name of the retention configuration object.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Number of days Config stores your historical information.
     * </p>
     * <note>
     * <p>
     * Currently, only applicable to the configuration item history.
     * </p>
     * </note>
     * 
     * @return Number of days Config stores your historical information.</p> <note>
     *         <p>
     *         Currently, only applicable to the configuration item history.
     *         </p>
     */
    public final Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionConfiguration)) {
            return false;
        }
        RetentionConfiguration other = (RetentionConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionConfiguration").add("Name", name())
                .add("RetentionPeriodInDays", retentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RetentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetentionConfiguration, T> g) {
        return obj -> g.apply((RetentionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionConfiguration> {
        /**
         * <p>
         * The name of the retention configuration object.
         * </p>
         * 
         * @param name
         *        The name of the retention configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Number of days Config stores your historical information.
         * </p>
         * <note>
         * <p>
         * Currently, only applicable to the configuration item history.
         * </p>
         * </note>
         * 
         * @param retentionPeriodInDays
         *        Number of days Config stores your historical information.</p> <note>
         *        <p>
         *        Currently, only applicable to the configuration item history.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionConfiguration model) {
            name(model.name);
            retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        @Override
        public RetentionConfiguration build() {
            return new RetentionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
