/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns details of a resource evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceEvaluation.Builder, ResourceEvaluation> {
    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceEvaluationId").getter(getter(ResourceEvaluation::resourceEvaluationId))
            .setter(setter(Builder::resourceEvaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build())
            .build();

    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMode").getter(getter(ResourceEvaluation::evaluationModeAsString))
            .setter(setter(Builder::evaluationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()).build();

    private static final SdkField<Instant> EVALUATION_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationStartTimestamp").getter(getter(ResourceEvaluation::evaluationStartTimestamp))
            .setter(setter(Builder::evaluationStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EVALUATION_ID_FIELD,
            EVALUATION_MODE_FIELD, EVALUATION_START_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceEvaluationId;

    private final String evaluationMode;

    private final Instant evaluationStartTimestamp;

    private ResourceEvaluation(BuilderImpl builder) {
        this.resourceEvaluationId = builder.resourceEvaluationId;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationStartTimestamp = builder.evaluationStartTimestamp;
    }

    /**
     * <p>
     * The ResourceEvaluationId of a evaluation.
     * </p>
     * 
     * @return The ResourceEvaluationId of a evaluation.
     */
    public final String resourceEvaluationId() {
        return resourceEvaluationId;
    }

    /**
     * <p>
     * The mode of an evaluation. The valid values are Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(evaluationMode);
    }

    /**
     * <p>
     * The mode of an evaluation. The valid values are Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final String evaluationModeAsString() {
        return evaluationMode;
    }

    /**
     * <p>
     * The starting time of an execution.
     * </p>
     * 
     * @return The starting time of an execution.
     */
    public final Instant evaluationStartTimestamp() {
        return evaluationStartTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceEvaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStartTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEvaluation)) {
            return false;
        }
        ResourceEvaluation other = (ResourceEvaluation) obj;
        return Objects.equals(resourceEvaluationId(), other.resourceEvaluationId())
                && Objects.equals(evaluationModeAsString(), other.evaluationModeAsString())
                && Objects.equals(evaluationStartTimestamp(), other.evaluationStartTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceEvaluation").add("ResourceEvaluationId", resourceEvaluationId())
                .add("EvaluationMode", evaluationModeAsString()).add("EvaluationStartTimestamp", evaluationStartTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceEvaluationId":
            return Optional.ofNullable(clazz.cast(resourceEvaluationId()));
        case "EvaluationMode":
            return Optional.ofNullable(clazz.cast(evaluationModeAsString()));
        case "EvaluationStartTimestamp":
            return Optional.ofNullable(clazz.cast(evaluationStartTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
        map.put("EvaluationMode", EVALUATION_MODE_FIELD);
        map.put("EvaluationStartTimestamp", EVALUATION_START_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceEvaluation, T> g) {
        return obj -> g.apply((ResourceEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceEvaluation> {
        /**
         * <p>
         * The ResourceEvaluationId of a evaluation.
         * </p>
         * 
         * @param resourceEvaluationId
         *        The ResourceEvaluationId of a evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluationId(String resourceEvaluationId);

        /**
         * <p>
         * The mode of an evaluation. The valid values are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(String evaluationMode);

        /**
         * <p>
         * The mode of an evaluation. The valid values are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(EvaluationMode evaluationMode);

        /**
         * <p>
         * The starting time of an execution.
         * </p>
         * 
         * @param evaluationStartTimestamp
         *        The starting time of an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationStartTimestamp(Instant evaluationStartTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String resourceEvaluationId;

        private String evaluationMode;

        private Instant evaluationStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEvaluation model) {
            resourceEvaluationId(model.resourceEvaluationId);
            evaluationMode(model.evaluationMode);
            evaluationStartTimestamp(model.evaluationStartTimestamp);
        }

        public final String getResourceEvaluationId() {
            return resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        public final String getEvaluationMode() {
            return evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final Instant getEvaluationStartTimestamp() {
            return evaluationStartTimestamp;
        }

        public final void setEvaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
        }

        @Override
        public final Builder evaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
            return this;
        }

        @Override
        public ResourceEvaluation build() {
            return new ResourceEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
