/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConformancePackComplianceScoresRequest extends ConfigRequest implements
        ToCopyableBuilder<ListConformancePackComplianceScoresRequest.Builder, ListConformancePackComplianceScoresRequest> {
    private static final SdkField<ConformancePackComplianceScoresFilters> FILTERS_FIELD = SdkField
            .<ConformancePackComplianceScoresFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListConformancePackComplianceScoresRequest::filters)).setter(setter(Builder::filters))
            .constructor(ConformancePackComplianceScoresFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListConformancePackComplianceScoresRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListConformancePackComplianceScoresRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListConformancePackComplianceScoresRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConformancePackComplianceScoresRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SORT_ORDER_FIELD, SORT_BY_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConformancePackComplianceScoresFilters filters;

    private final String sortOrder;

    private final String sortBy;

    private final Integer limit;

    private final String nextToken;

    private ListConformancePackComplianceScoresRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.
     * </p>
     * 
     * @return Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.
     */
    public final ConformancePackComplianceScoresFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Determines the order in which conformance pack compliance scores are sorted. Either in ascending or descending
     * order.
     * </p>
     * <p>
     * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack.
     * Conformance pack compliance scores are sorted in reverse alphabetical order if you enter <code>DESCENDING</code>.
     * </p>
     * <p>
     * You can sort conformance pack compliance scores by the numerical value of the compliance score by entering
     * <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>,
     * conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by
     * ascending order and first when sorting by descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
     *         descending order.</p>
     *         <p>
     *         By default, conformance pack compliance scores are sorted in alphabetical order by name of the
     *         conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you
     *         enter <code>DESCENDING</code>.
     *         </p>
     *         <p>
     *         You can sort conformance pack compliance scores by the numerical value of the compliance score by
     *         entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by
     *         <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be
     *         last when sorting by ascending order and first when sorting by descending order.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Determines the order in which conformance pack compliance scores are sorted. Either in ascending or descending
     * order.
     * </p>
     * <p>
     * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack.
     * Conformance pack compliance scores are sorted in reverse alphabetical order if you enter <code>DESCENDING</code>.
     * </p>
     * <p>
     * You can sort conformance pack compliance scores by the numerical value of the compliance score by entering
     * <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>,
     * conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by
     * ascending order and first when sorting by descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
     *         descending order.</p>
     *         <p>
     *         By default, conformance pack compliance scores are sorted in alphabetical order by name of the
     *         conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you
     *         enter <code>DESCENDING</code>.
     *         </p>
     *         <p>
     *         You can sort conformance pack compliance scores by the numerical value of the compliance score by
     *         entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by
     *         <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be
     *         last when sorting by ascending order and first when sorting by descending order.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * Sorts your conformance pack compliance scores in either ascending or descending order, depending on
     * <code>SortOrder</code>.
     * </p>
     * <p>
     * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack.
     * Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the compliance
     * score.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sorts your conformance pack compliance scores in either ascending or descending order, depending on
     *         <code>SortOrder</code>.</p>
     *         <p>
     *         By default, conformance pack compliance scores are sorted in alphabetical order by name of the
     *         conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical
     *         value of the compliance score.
     * @see SortBy
     */
    public final SortBy sortBy() {
        return SortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sorts your conformance pack compliance scores in either ascending or descending order, depending on
     * <code>SortOrder</code>.
     * </p>
     * <p>
     * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance pack.
     * Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the compliance
     * score.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sorts your conformance pack compliance scores in either ascending or descending order, depending on
     *         <code>SortOrder</code>.</p>
     *         <p>
     *         By default, conformance pack compliance scores are sorted in alphabetical order by name of the
     *         conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical
     *         value of the compliance score.
     * @see SortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of conformance pack compliance scores returned on each page.
     * </p>
     * 
     * @return The maximum number of conformance pack compliance scores returned on each page.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string in a prior request that you can use to get the paginated response for the next
     * set of conformance pack compliance scores.
     * </p>
     * 
     * @return The <code>nextToken</code> string in a prior request that you can use to get the paginated response for
     *         the next set of conformance pack compliance scores.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConformancePackComplianceScoresRequest)) {
            return false;
        }
        ListConformancePackComplianceScoresRequest other = (ListConformancePackComplianceScoresRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConformancePackComplianceScoresRequest").add("Filters", filters())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConformancePackComplianceScoresRequest, T> g) {
        return obj -> g.apply((ListConformancePackComplianceScoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConformancePackComplianceScoresRequest> {
        /**
         * <p>
         * Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.
         * </p>
         * 
         * @param filters
         *        Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ConformancePackComplianceScoresFilters filters);

        /**
         * <p>
         * Filters the results based on the <code>ConformancePackComplianceScoresFilters</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConformancePackComplianceScoresFilters.Builder} avoiding the need to create one manually via
         * {@link ConformancePackComplianceScoresFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConformancePackComplianceScoresFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(ConformancePackComplianceScoresFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ConformancePackComplianceScoresFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ConformancePackComplianceScoresFilters)
         */
        default Builder filters(Consumer<ConformancePackComplianceScoresFilters.Builder> filters) {
            return filters(ConformancePackComplianceScoresFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
         * descending order.
         * </p>
         * <p>
         * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance
         * pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you enter
         * <code>DESCENDING</code>.
         * </p>
         * <p>
         * You can sort conformance pack compliance scores by the numerical value of the compliance score by entering
         * <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>
         * , conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by
         * ascending order and first when sorting by descending order.
         * </p>
         * 
         * @param sortOrder
         *        Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
         *        descending order.</p>
         *        <p>
         *        By default, conformance pack compliance scores are sorted in alphabetical order by name of the
         *        conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you
         *        enter <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        You can sort conformance pack compliance scores by the numerical value of the compliance score by
         *        entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by
         *        <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will
         *        be last when sorting by ascending order and first when sorting by descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
         * descending order.
         * </p>
         * <p>
         * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance
         * pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you enter
         * <code>DESCENDING</code>.
         * </p>
         * <p>
         * You can sort conformance pack compliance scores by the numerical value of the compliance score by entering
         * <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by <code>SCORE</code>
         * , conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will be last when sorting by
         * ascending order and first when sorting by descending order.
         * </p>
         * 
         * @param sortOrder
         *        Determines the order in which conformance pack compliance scores are sorted. Either in ascending or
         *        descending order.</p>
         *        <p>
         *        By default, conformance pack compliance scores are sorted in alphabetical order by name of the
         *        conformance pack. Conformance pack compliance scores are sorted in reverse alphabetical order if you
         *        enter <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        You can sort conformance pack compliance scores by the numerical value of the compliance score by
         *        entering <code>SCORE</code> in the <code>SortBy</code> action. When compliance scores are sorted by
         *        <code>SCORE</code>, conformance packs with a compliance score of <code>INSUFFICIENT_DATA</code> will
         *        be last when sorting by ascending order and first when sorting by descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * Sorts your conformance pack compliance scores in either ascending or descending order, depending on
         * <code>SortOrder</code>.
         * </p>
         * <p>
         * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance
         * pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the
         * compliance score.
         * </p>
         * 
         * @param sortBy
         *        Sorts your conformance pack compliance scores in either ascending or descending order, depending on
         *        <code>SortOrder</code>.</p>
         *        <p>
         *        By default, conformance pack compliance scores are sorted in alphabetical order by name of the
         *        conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the
         *        numerical value of the compliance score.
         * @see SortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sorts your conformance pack compliance scores in either ascending or descending order, depending on
         * <code>SortOrder</code>.
         * </p>
         * <p>
         * By default, conformance pack compliance scores are sorted in alphabetical order by name of the conformance
         * pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the numerical value of the
         * compliance score.
         * </p>
         * 
         * @param sortBy
         *        Sorts your conformance pack compliance scores in either ascending or descending order, depending on
         *        <code>SortOrder</code>.</p>
         *        <p>
         *        By default, conformance pack compliance scores are sorted in alphabetical order by name of the
         *        conformance pack. Enter <code>SCORE</code>, to sort conformance pack compliance scores by the
         *        numerical value of the compliance score.
         * @see SortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortBy
         */
        Builder sortBy(SortBy sortBy);

        /**
         * <p>
         * The maximum number of conformance pack compliance scores returned on each page.
         * </p>
         * 
         * @param limit
         *        The maximum number of conformance pack compliance scores returned on each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string in a prior request that you can use to get the paginated response for the
         * next set of conformance pack compliance scores.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string in a prior request that you can use to get the paginated response
         *        for the next set of conformance pack compliance scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private ConformancePackComplianceScoresFilters filters;

        private String sortOrder;

        private String sortBy;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConformancePackComplianceScoresRequest model) {
            super(model);
            filters(model.filters);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final ConformancePackComplianceScoresFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ConformancePackComplianceScoresFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ConformancePackComplianceScoresFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConformancePackComplianceScoresRequest build() {
            return new ListConformancePackComplianceScoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
