/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceDetailsByResourceRequest extends ConfigRequest implements
        ToCopyableBuilder<GetComplianceDetailsByResourceRequest.Builder, GetComplianceDetailsByResourceRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetComplianceDetailsByResourceRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(GetComplianceDetailsByResourceRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<List<String>> COMPLIANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ComplianceTypes")
            .getter(getter(GetComplianceDetailsByResourceRequest::complianceTypesAsStrings))
            .setter(setter(Builder::complianceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetComplianceDetailsByResourceRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceEvaluationId").getter(getter(GetComplianceDetailsByResourceRequest::resourceEvaluationId))
            .setter(setter(Builder::resourceEvaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD, COMPLIANCE_TYPES_FIELD, NEXT_TOKEN_FIELD, RESOURCE_EVALUATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceType;

    private final String resourceId;

    private final List<String> complianceTypes;

    private final String nextToken;

    private final String resourceEvaluationId;

    private GetComplianceDetailsByResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
        this.resourceEvaluationId = builder.resourceEvaluationId;
    }

    /**
     * <p>
     * The type of the Amazon Web Services resource for which you want compliance information.
     * </p>
     * 
     * @return The type of the Amazon Web Services resource for which you want compliance information.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services resource for which you want compliance information.
     * </p>
     * 
     * @return The ID of the Amazon Web Services resource for which you want compliance information.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule cannot
     * be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code> for
     * filtering results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceTypes} method.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
     *         rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
     *         <code>ComplianceType</code> for filtering results.
     */
    public final List<ComplianceType> complianceTypes() {
        return ComplianceTypesCopier.copyStringToEnum(complianceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComplianceTypes() {
        return complianceTypes != null && !(complianceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule cannot
     * be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code> for
     * filtering results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceTypes} method.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
     *         rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
     *         <code>ComplianceType</code> for filtering results.
     */
    public final List<String> complianceTypesAsStrings() {
        return complianceTypes;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The unique ID of Amazon Web Services resource execution for which you want to retrieve evaluation results.
     * </p>
     * <note>
     * <p>
     * You need to only provide either a <code>ResourceEvaluationID</code> or a <code>ResourceID </code>and
     * <code>ResourceType</code>.
     * </p>
     * </note>
     * 
     * @return The unique ID of Amazon Web Services resource execution for which you want to retrieve evaluation
     *         results. </p> <note>
     *         <p>
     *         You need to only provide either a <code>ResourceEvaluationID</code> or a <code>ResourceID </code>and
     *         <code>ResourceType</code>.
     *         </p>
     */
    public final String resourceEvaluationId() {
        return resourceEvaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceTypes() ? complianceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceEvaluationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByResourceRequest)) {
            return false;
        }
        GetComplianceDetailsByResourceRequest other = (GetComplianceDetailsByResourceRequest) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceId(), other.resourceId())
                && hasComplianceTypes() == other.hasComplianceTypes()
                && Objects.equals(complianceTypesAsStrings(), other.complianceTypesAsStrings())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceEvaluationId(), other.resourceEvaluationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComplianceDetailsByResourceRequest").add("ResourceType", resourceType())
                .add("ResourceId", resourceId()).add("ComplianceTypes", hasComplianceTypes() ? complianceTypesAsStrings() : null)
                .add("NextToken", nextToken()).add("ResourceEvaluationId", resourceEvaluationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ComplianceTypes":
            return Optional.ofNullable(clazz.cast(complianceTypesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceEvaluationId":
            return Optional.ofNullable(clazz.cast(resourceEvaluationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ComplianceTypes", COMPLIANCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByResourceRequest, T> g) {
        return obj -> g.apply((GetComplianceDetailsByResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceDetailsByResourceRequest> {
        /**
         * <p>
         * The type of the Amazon Web Services resource for which you want compliance information.
         * </p>
         * 
         * @param resourceType
         *        The type of the Amazon Web Services resource for which you want compliance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the Amazon Web Services resource for which you want compliance information.
         * </p>
         * 
         * @param resourceId
         *        The ID of the Amazon Web Services resource for which you want compliance information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule
         * cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code>
         * for filtering results.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
         *        rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
         *        <code>ComplianceType</code> for filtering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypesWithStrings(Collection<String> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule
         * cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code>
         * for filtering results.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
         *        rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
         *        <code>ComplianceType</code> for filtering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypesWithStrings(String... complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule
         * cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code>
         * for filtering results.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
         *        rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
         *        <code>ComplianceType</code> for filtering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(Collection<ComplianceType> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config rule
         * cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a <code>ComplianceType</code>
         * for filtering results.
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> is a valid <code>ComplianceType</code> that is returned when an Config
         *        rule cannot be evaluated. However, <code>INSUFFICIENT_DATA</code> cannot be used as a
         *        <code>ComplianceType</code> for filtering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceTypes(ComplianceType... complianceTypes);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique ID of Amazon Web Services resource execution for which you want to retrieve evaluation results.
         * </p>
         * <note>
         * <p>
         * You need to only provide either a <code>ResourceEvaluationID</code> or a <code>ResourceID </code>and
         * <code>ResourceType</code>.
         * </p>
         * </note>
         * 
         * @param resourceEvaluationId
         *        The unique ID of Amazon Web Services resource execution for which you want to retrieve evaluation
         *        results. </p> <note>
         *        <p>
         *        You need to only provide either a <code>ResourceEvaluationID</code> or a <code>ResourceID </code>and
         *        <code>ResourceType</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluationId(String resourceEvaluationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<String> complianceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String resourceEvaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByResourceRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            complianceTypesWithStrings(model.complianceTypes);
            nextToken(model.nextToken);
            resourceEvaluationId(model.resourceEvaluationId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getComplianceTypes() {
            if (complianceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return complianceTypes;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @Override
        public final Builder complianceTypesWithStrings(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypesWithStrings(String... complianceTypes) {
            complianceTypesWithStrings(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        public final Builder complianceTypes(Collection<ComplianceType> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copyEnumToString(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType... complianceTypes) {
            complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceEvaluationId() {
            return resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceDetailsByResourceRequest build() {
            return new GetComplianceDetailsByResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
