/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigRulesRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigRulesRequest.Builder, DescribeConfigRulesRequest> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigRuleNames")
            .getter(getter(DescribeConfigRulesRequest::configRuleNames))
            .setter(setter(Builder::configRuleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<DescribeConfigRulesFilters> FILTERS_FIELD = SdkField
            .<DescribeConfigRulesFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(DescribeConfigRulesRequest::filters)).setter(setter(Builder::filters))
            .constructor(DescribeConfigRulesFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> configRuleNames;

    private final String nextToken;

    private final DescribeConfigRulesFilters filters;

    private DescribeConfigRulesRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigRuleNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigRuleNames() {
        return configRuleNames != null && !(configRuleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the Config rules for which you want details. If you do not specify any names, Config returns details
     * for all your rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigRuleNames} method.
     * </p>
     * 
     * @return The names of the Config rules for which you want details. If you do not specify any names, Config returns
     *         details for all your rules.
     */
    public final List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Returns a list of Detective or Proactive Config rules. By default, this API returns an unfiltered list. For more
     * information on Detective or Proactive Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html"> <b>Evaluation
     * Mode</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * 
     * @return Returns a list of Detective or Proactive Config rules. By default, this API returns an unfiltered list.
     *         For more information on Detective or Proactive Config rules, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html"> <b>Evaluation
     *         Mode</b> </a> in the <i>Config Developer Guide</i>.
     */
    public final DescribeConfigRulesFilters filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigRuleNames() ? configRuleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesRequest)) {
            return false;
        }
        DescribeConfigRulesRequest other = (DescribeConfigRulesRequest) obj;
        return hasConfigRuleNames() == other.hasConfigRuleNames() && Objects.equals(configRuleNames(), other.configRuleNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigRulesRequest")
                .add("ConfigRuleNames", hasConfigRuleNames() ? configRuleNames() : null).add("NextToken", nextToken())
                .add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.ofNullable(clazz.cast(configRuleNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigRuleNames", CONFIG_RULE_NAMES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigRulesRequest, T> g) {
        return obj -> g.apply((DescribeConfigRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConfigRulesRequest> {
        /**
         * <p>
         * The names of the Config rules for which you want details. If you do not specify any names, Config returns
         * details for all your rules.
         * </p>
         * 
         * @param configRuleNames
         *        The names of the Config rules for which you want details. If you do not specify any names, Config
         *        returns details for all your rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * The names of the Config rules for which you want details. If you do not specify any names, Config returns
         * details for all your rules.
         * </p>
         * 
         * @param configRuleNames
         *        The names of the Config rules for which you want details. If you do not specify any names, Config
         *        returns details for all your rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns a list of Detective or Proactive Config rules. By default, this API returns an unfiltered list. For
         * more information on Detective or Proactive Config rules, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html"> <b>Evaluation
         * Mode</b> </a> in the <i>Config Developer Guide</i>.
         * </p>
         * 
         * @param filters
         *        Returns a list of Detective or Proactive Config rules. By default, this API returns an unfiltered
         *        list. For more information on Detective or Proactive Config rules, see <a
         *        href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html">
         *        <b>Evaluation Mode</b> </a> in the <i>Config Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeConfigRulesFilters filters);

        /**
         * <p>
         * Returns a list of Detective or Proactive Config rules. By default, this API returns an unfiltered list. For
         * more information on Detective or Proactive Config rules, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config-rules.html"> <b>Evaluation
         * Mode</b> </a> in the <i>Config Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribeConfigRulesFilters.Builder}
         * avoiding the need to create one manually via {@link DescribeConfigRulesFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribeConfigRulesFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(DescribeConfigRulesFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link DescribeConfigRulesFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(DescribeConfigRulesFilters)
         */
        default Builder filters(Consumer<DescribeConfigRulesFilters.Builder> filters) {
            return filters(DescribeConfigRulesFilters.builder().applyMutation(filters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private DescribeConfigRulesFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesRequest model) {
            super(model);
            configRuleNames(model.configRuleNames);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Collection<String> getConfigRuleNames() {
            if (configRuleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return configRuleNames;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final DescribeConfigRulesFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(DescribeConfigRulesFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(DescribeConfigRulesFilters filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigRulesRequest build() {
            return new DescribeConfigRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
