/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the configuration recorder.
 * </p>
 * <p>
 * For a detailed status of recording events over time, add your Config events to CloudWatch metrics and use CloudWatch
 * metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorderStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorderStatus.Builder, ConfigurationRecorderStatus> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfigurationRecorderStatus::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfigurationRecorderStatus::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStartTime").getter(getter(ConfigurationRecorderStatus::lastStartTime))
            .setter(setter(Builder::lastStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()).build();

    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStopTime").getter(getter(ConfigurationRecorderStatus::lastStopTime))
            .setter(setter(Builder::lastStopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()).build();

    private static final SdkField<Boolean> RECORDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("recording").getter(getter(ConfigurationRecorderStatus::recording)).setter(setter(Builder::recording))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastStatus").getter(getter(ConfigurationRecorderStatus::lastStatusAsString))
            .setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastErrorCode").getter(getter(ConfigurationRecorderStatus::lastErrorCode))
            .setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastErrorMessage").getter(getter(ConfigurationRecorderStatus::lastErrorMessage))
            .setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChangeTime").getter(getter(ConfigurationRecorderStatus::lastStatusChangeTime))
            .setter(setter(Builder::lastStatusChangeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build())
            .build();

    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("servicePrincipal").getter(getter(ConfigurationRecorderStatus::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePrincipal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD, RECORDING_FIELD, LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD,
            LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD, SERVICE_PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Instant lastStartTime;

    private final Instant lastStopTime;

    private final Boolean recording;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastStatusChangeTime;

    private final String servicePrincipal;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
        this.servicePrincipal = builder.servicePrincipal;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration recorder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration recorder.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the configuration recorder.
     * </p>
     * 
     * @return The name of the configuration recorder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time the recorder was last started.
     * </p>
     * 
     * @return The time the recorder was last started.
     */
    public final Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The time the recorder was last stopped.
     * </p>
     * 
     * @return The time the recorder was last stopped.
     */
    public final Instant lastStopTime() {
        return lastStopTime;
    }

    /**
     * <p>
     * Specifies whether or not the recorder is currently recording.
     * </p>
     * 
     * @return Specifies whether or not the recorder is currently recording.
     */
    public final Boolean recording() {
        return recording;
    }

    /**
     * <p>
     * The status of the latest recording event processed by the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The status of the latest recording event processed by the recorder.
     * @see RecorderStatus
     */
    public final RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * The status of the latest recording event processed by the recorder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The status of the latest recording event processed by the recorder.
     * @see RecorderStatus
     */
    public final String lastStatusAsString() {
        return lastStatus;
    }

    /**
     * <p>
     * The latest error code from when the recorder last failed.
     * </p>
     * 
     * @return The latest error code from when the recorder last failed.
     */
    public final String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The latest error message from when the recorder last failed.
     * </p>
     * 
     * @return The latest error message from when the recorder last failed.
     */
    public final String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time of the latest change in status of an recording event processed by the recorder.
     * </p>
     * 
     * @return The time of the latest change in status of an recording event processed by the recorder.
     */
    public final Instant lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    /**
     * <p>
     * For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.
     * </p>
     * 
     * @return For service-linked configuration recorders, the service principal of the linked Amazon Web Services
     *         service.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(recording());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeTime());
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(lastStartTime(), other.lastStartTime()) && Objects.equals(lastStopTime(), other.lastStopTime())
                && Objects.equals(recording(), other.recording())
                && Objects.equals(lastStatusAsString(), other.lastStatusAsString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastStatusChangeTime(), other.lastStatusChangeTime())
                && Objects.equals(servicePrincipal(), other.servicePrincipal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationRecorderStatus").add("Arn", arn()).add("Name", name())
                .add("LastStartTime", lastStartTime()).add("LastStopTime", lastStopTime()).add("Recording", recording())
                .add("LastStatus", lastStatusAsString()).add("LastErrorCode", lastErrorCode())
                .add("LastErrorMessage", lastErrorMessage()).add("LastStatusChangeTime", lastStatusChangeTime())
                .add("ServicePrincipal", servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lastStartTime":
            return Optional.ofNullable(clazz.cast(lastStartTime()));
        case "lastStopTime":
            return Optional.ofNullable(clazz.cast(lastStopTime()));
        case "recording":
            return Optional.ofNullable(clazz.cast(recording()));
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        case "lastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        case "lastStatusChangeTime":
            return Optional.ofNullable(clazz.cast(lastStatusChangeTime()));
        case "servicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("lastStopTime", LAST_STOP_TIME_FIELD);
        map.put("recording", RECORDING_FIELD);
        map.put("lastStatus", LAST_STATUS_FIELD);
        map.put("lastErrorCode", LAST_ERROR_CODE_FIELD);
        map.put("lastErrorMessage", LAST_ERROR_MESSAGE_FIELD);
        map.put("lastStatusChangeTime", LAST_STATUS_CHANGE_TIME_FIELD);
        map.put("servicePrincipal", SERVICE_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderStatus, T> g) {
        return obj -> g.apply((ConfigurationRecorderStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration recorder.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the configuration recorder.
         * </p>
         * 
         * @param name
         *        The name of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the recorder was last started.
         * </p>
         * 
         * @param lastStartTime
         *        The time the recorder was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The time the recorder was last stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time the recorder was last stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);

        /**
         * <p>
         * Specifies whether or not the recorder is currently recording.
         * </p>
         * 
         * @param recording
         *        Specifies whether or not the recorder is currently recording.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recording(Boolean recording);

        /**
         * <p>
         * The status of the latest recording event processed by the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The status of the latest recording event processed by the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The status of the latest recording event processed by the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The status of the latest recording event processed by the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(RecorderStatus lastStatus);

        /**
         * <p>
         * The latest error code from when the recorder last failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The latest error code from when the recorder last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The latest error message from when the recorder last failed.
         * </p>
         * 
         * @param lastErrorMessage
         *        The latest error message from when the recorder last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time of the latest change in status of an recording event processed by the recorder.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time of the latest change in status of an recording event processed by the recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Instant lastStatusChangeTime);

        /**
         * <p>
         * For service-linked configuration recorders, the service principal of the linked Amazon Web Services service.
         * </p>
         * 
         * @param servicePrincipal
         *        For service-linked configuration recorders, the service principal of the linked Amazon Web Services
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant lastStartTime;

        private Instant lastStopTime;

        private Boolean recording;

        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastStatusChangeTime;

        private String servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            arn(model.arn);
            name(model.name);
            lastStartTime(model.lastStartTime);
            lastStopTime(model.lastStopTime);
            recording(model.recording);
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastStatusChangeTime(model.lastStatusChangeTime);
            servicePrincipal(model.servicePrincipal);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final Boolean getRecording() {
            return recording;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final Instant getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        @Override
        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
