/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher;
import software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesPublisher;
import software.amazon.awssdk.services.config.paginators.ListConfigurationRecordersPublisher;
import software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresPublisher;
import software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesPublisher;
import software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsPublisher;
import software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher;
import software.amazon.awssdk.services.config.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher;
import software.amazon.awssdk.services.config.paginators.SelectResourceConfigPublisher;

/**
 * Service client for accessing Config Service asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Config</fullname>
 * <p>
 * Config provides a way to keep track of the configurations of all the Amazon Web Services resources associated with
 * your Amazon Web Services account. You can use Config to get the current and historical configurations of each Amazon
 * Web Services resource and also to get information about the relationship between the resources. An Amazon Web
 * Services resource can be an Amazon Compute Cloud (Amazon EC2) instance, an Elastic Block Store (EBS) volume, an
 * elastic network Interface (ENI), or a security group. For a complete list of resources currently supported by Config,
 * see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
 * >Supported Amazon Web Services resources</a>.
 * </p>
 * <p>
 * You can access and manage Config through the Amazon Web Services Management Console, the Amazon Web Services Command
 * Line Interface (Amazon Web Services CLI), the Config API, or the Amazon Web Services SDKs for Config. This reference
 * guide contains documentation for the Config API and the Amazon Web Services CLI commands that you can use to manage
 * Config. The Config API uses the Signature Version 4 protocol for signing requests. For more information about how to
 * sign a request with this protocol, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>. For detailed information about Config features and their associated actions or commands, as well as how
 * to work with Amazon Web Services Management Console, see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/WhatIsConfig.html">What Is Config</a> in the <i>Config
 * Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConfigAsyncClient extends AwsClient {
    String SERVICE_NAME = "config";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "config";

    /**
     * <p>
     * Adds all resource types specified in the <code>ResourceTypes</code> list to the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> of
     * specified configuration recorder and includes those resource types when recording.
     * </p>
     * <p>
     * For this operation, the specified configuration recorder must use a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a>
     * that is either <code>INCLUSION_BY_RESOURCE_TYPES</code> or <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     * </p>
     *
     * @param associateResourceTypesRequest
     * @return A Java Future containing the result of the AssociateResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.AssociateResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AssociateResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateResourceTypesResponse> associateResourceTypes(
            AssociateResourceTypesRequest associateResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds all resource types specified in the <code>ResourceTypes</code> list to the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> of
     * specified configuration recorder and includes those resource types when recording.
     * </p>
     * <p>
     * For this operation, the specified configuration recorder must use a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a>
     * that is either <code>INCLUSION_BY_RESOURCE_TYPES</code> or <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceTypesRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResourceTypesRequest#builder()}
     * </p>
     *
     * @param associateResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.AssociateResourceTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.AssociateResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AssociateResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateResourceTypesResponse> associateResourceTypes(
            Consumer<AssociateResourceTypesRequest.Builder> associateResourceTypesRequest) {
        return associateResourceTypes(AssociateResourceTypesRequest.builder().applyMutation(associateResourceTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAggregateResourceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            Consumer<BatchGetAggregateResourceConfigRequest.Builder> batchGetAggregateResourceConfigRequest) {
        return batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest.builder()
                .applyMutation(batchGetAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            Consumer<BatchGetResourceConfigRequest.Builder> batchGetResourceConfigRequest) {
        return batchGetResourceConfig(BatchGetResourceConfigRequest.builder().applyMutation(batchGetResourceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAggregationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAggregationAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            Consumer<DeleteAggregationAuthorizationRequest.Builder> deleteAggregationAuthorizationRequest) {
        return deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest.builder()
                .applyMutation(deleteAggregationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteConfigRuleRequest
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(
            Consumer<DeleteConfigRuleRequest.Builder> deleteConfigRuleRequest) {
        return deleteConfigRule(DeleteConfigRuleRequest.builder().applyMutation(deleteConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationAggregatorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationAggregatorRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            Consumer<DeleteConfigurationAggregatorRequest.Builder> deleteConfigurationAggregatorRequest) {
        return deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest.builder()
                .applyMutation(deleteConfigurationAggregatorRequest).build());
    }

    /**
     * <p>
     * Deletes the customer managed configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new customer managed configuration recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> operation.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>UnmodifiableEntityException The requested operation is not valid.</p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html">
     *         PutConfigurationRecorder</a>, you will see this exception because you cannot use this operation to create
     *         a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a> operation to create a service-linked configuration recorder.
     *         </p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html">
     *         DeleteConfigurationRecorder</a>, you will see this exception because you cannot use this operation to
     *         delete a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html">
     *         StartConfigurationRecorder</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a>, you will see this exception because these operations do not affect
     *         service-linked configuration recorders. Service-linked configuration recorders are always recording. To
     *         stop recording, you must delete the service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the customer managed configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new customer managed configuration recorder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationRecorderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest.Builder} to create
     *        a request. The request object for the <code>DeleteConfigurationRecorder</code> operation.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>UnmodifiableEntityException The requested operation is not valid.</p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html">
     *         PutConfigurationRecorder</a>, you will see this exception because you cannot use this operation to create
     *         a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a> operation to create a service-linked configuration recorder.
     *         </p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html">
     *         DeleteConfigurationRecorder</a>, you will see this exception because you cannot use this operation to
     *         delete a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html">
     *         StartConfigurationRecorder</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a>, you will see this exception because these operations do not affect
     *         service-linked configuration recorders. Service-linked configuration recorders are always recording. To
     *         stop recording, you must delete the service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            Consumer<DeleteConfigurationRecorderRequest.Builder> deleteConfigurationRecorderRequest) {
        return deleteConfigurationRecorder(DeleteConfigurationRecorderRequest.builder()
                .applyMutation(deleteConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteConformancePackRequest
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            DeleteConformancePackRequest deleteConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConformancePackRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteConformancePackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConformancePackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            Consumer<DeleteConformancePackRequest.Builder> deleteConformancePackRequest) {
        return deleteConformancePack(DeleteConformancePackRequest.builder().applyMutation(deleteConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the customer managed configuration recorder. You can
     * use the <a>StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the customer managed configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the customer managed configuration recorder. You can
     * use the <a>StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeliveryChannelRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest.Builder} to create a
     *        request. The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in
     *        JSON format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the customer managed configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            Consumer<DeleteDeliveryChannelRequest.Builder> deleteDeliveryChannelRequest) {
        return deleteDeliveryChannel(DeleteDeliveryChannelRequest.builder().applyMutation(deleteDeliveryChannelRequest).build());
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationResultsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEvaluationResultsRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            Consumer<DeleteEvaluationResultsRequest.Builder> deleteEvaluationResultsRequest) {
        return deleteEvaluationResults(DeleteEvaluationResultsRequest.builder().applyMutation(deleteEvaluationResultsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            Consumer<DeleteOrganizationConfigRuleRequest.Builder> deleteOrganizationConfigRuleRequest) {
        return deleteOrganizationConfigRule(DeleteOrganizationConfigRuleRequest.builder()
                .applyMutation(deleteOrganizationConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConformancePackRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            Consumer<DeleteOrganizationConformancePackRequest.Builder> deleteOrganizationConformancePackRequest) {
        return deleteOrganizationConformancePack(DeleteOrganizationConformancePackRequest.builder()
                .applyMutation(deleteOrganizationConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePendingAggregationRequestRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePendingAggregationRequestRequest#builder()}
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            Consumer<DeletePendingAggregationRequestRequest.Builder> deletePendingAggregationRequestRequest) {
        return deletePendingAggregationRequest(DeletePendingAggregationRequestRequest.builder()
                .applyMutation(deletePendingAggregationRequestRequest).build());
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         Amazon Web Services Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the
     *         config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html">
     *         PutOrganizationConfigRule</a>, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">
     *         PutConformancePack</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html"
     *         >PutOrganizationConformancePack</a>, a conformance pack cannot be created because you do not have the
     *         following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, a service-linked configuration recorder cannot be created
     *         because you do not have the following permissions: IAM <code>CreateServiceLinkedRole</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         Amazon Web Services Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the
     *         config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html">
     *         PutOrganizationConfigRule</a>, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">
     *         PutConformancePack</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html"
     *         >PutOrganizationConformancePack</a>, a conformance pack cannot be created because you do not have the
     *         following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, a service-linked configuration recorder cannot be created
     *         because you do not have the following permissions: IAM <code>CreateServiceLinkedRole</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            Consumer<DeleteRemediationConfigurationRequest.Builder> deleteRemediationConfigurationRequest) {
        return deleteRemediationConfiguration(DeleteRemediationConfigurationRequest.builder()
                .applyMutation(deleteRemediationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param deleteRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            Consumer<DeleteRemediationExceptionsRequest.Builder> deleteRemediationExceptionsRequest) {
        return deleteRemediationExceptions(DeleteRemediationExceptionsRequest.builder()
                .applyMutation(deleteRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            DeleteResourceConfigRequest deleteResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceConfigRequest#builder()}
     * </p>
     *
     * @param deleteResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            Consumer<DeleteResourceConfigRequest.Builder> deleteResourceConfigRequest) {
        return deleteResourceConfig(DeleteResourceConfigRequest.builder().applyMutation(deleteResourceConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRetentionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            Consumer<DeleteRetentionConfigurationRequest.Builder> deleteRetentionConfigurationRequest) {
        return deleteRetentionConfiguration(DeleteRetentionConfigurationRequest.builder()
                .applyMutation(deleteRetentionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing service-linked configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new service-linked configuration recorder for the same service.
     * </p>
     * <note>
     * <p>
     * <b>The recording scope determines if you receive configuration items</b>
     * </p>
     * <p>
     * The recording scope is set by the service that is linked to the configuration recorder and determines whether you
     * receive configuration items (CIs) in the delivery channel. If the recording scope is internal, you will not
     * receive CIs in the delivery channel.
     * </p>
     * </note>
     *
     * @param deleteServiceLinkedConfigurationRecorderRequest
     * @return A Java Future containing the result of the DeleteServiceLinkedConfigurationRecorder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteServiceLinkedConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteServiceLinkedConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> deleteServiceLinkedConfigurationRecorder(
            DeleteServiceLinkedConfigurationRecorderRequest deleteServiceLinkedConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing service-linked configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new service-linked configuration recorder for the same service.
     * </p>
     * <note>
     * <p>
     * <b>The recording scope determines if you receive configuration items</b>
     * </p>
     * <p>
     * The recording scope is set by the service that is linked to the configuration recorder and determines whether you
     * receive configuration items (CIs) in the delivery channel. If the recording scope is internal, you will not
     * receive CIs in the delivery channel.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceLinkedConfigurationRecorderRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceLinkedConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param deleteServiceLinkedConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteServiceLinkedConfigurationRecorder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteServiceLinkedConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteServiceLinkedConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> deleteServiceLinkedConfigurationRecorder(
            Consumer<DeleteServiceLinkedConfigurationRecorderRequest.Builder> deleteServiceLinkedConfigurationRecorderRequest) {
        return deleteServiceLinkedConfigurationRecorder(DeleteServiceLinkedConfigurationRecorderRequest.builder()
                .applyMutation(deleteServiceLinkedConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStoredQueryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteStoredQueryRequest#builder()}
     * </p>
     *
     * @param deleteStoredQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(
            Consumer<DeleteStoredQueryRequest.Builder> deleteStoredQueryRequest) {
        return deleteStoredQuery(DeleteStoredQueryRequest.builder().applyMutation(deleteStoredQueryRequest).build());
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeliverConfigSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeliverConfigSnapshotRequest#builder()}
     * </p>
     *
     * @param deliverConfigSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest.Builder} to create a
     *        request. The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            Consumer<DeliverConfigSnapshotRequest.Builder> deliverConfigSnapshotRequest) {
        return deliverConfigSnapshot(DeliverConfigSnapshotRequest.builder().applyMutation(deliverConfigSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            Consumer<DescribeAggregateComplianceByConfigRulesRequest.Builder> describeAggregateComplianceByConfigRulesRequest) {
        return describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest.builder()
                .applyMutation(describeAggregateComplianceByConfigRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesPublisher describeAggregateComplianceByConfigRulesPaginator(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        return new DescribeAggregateComplianceByConfigRulesPublisher(this, describeAggregateComplianceByConfigRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesPublisher describeAggregateComplianceByConfigRulesPaginator(
            Consumer<DescribeAggregateComplianceByConfigRulesRequest.Builder> describeAggregateComplianceByConfigRulesRequest) {
        return describeAggregateComplianceByConfigRulesPaginator(DescribeAggregateComplianceByConfigRulesRequest.builder()
                .applyMutation(describeAggregateComplianceByConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the existing and deleted conformance packs and their associated compliance status with the
     * count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count
     * which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the existing and deleted conformance packs and their associated compliance status with the
     * count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count
     * which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            Consumer<DescribeAggregateComplianceByConformancePacksRequest.Builder> describeAggregateComplianceByConformancePacksRequest) {
        return describeAggregateComplianceByConformancePacks(DescribeAggregateComplianceByConformancePacksRequest.builder()
                .applyMutation(describeAggregateComplianceByConformancePacksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksPublisher describeAggregateComplianceByConformancePacksPaginator(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        return new DescribeAggregateComplianceByConformancePacksPublisher(this,
                describeAggregateComplianceByConformancePacksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksPublisher describeAggregateComplianceByConformancePacksPaginator(
            Consumer<DescribeAggregateComplianceByConformancePacksRequest.Builder> describeAggregateComplianceByConformancePacksRequest) {
        return describeAggregateComplianceByConformancePacksPaginator(DescribeAggregateComplianceByConformancePacksRequest
                .builder().applyMutation(describeAggregateComplianceByConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAggregationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            Consumer<DescribeAggregationAuthorizationsRequest.Builder> describeAggregationAuthorizationsRequest) {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder()
                .applyMutation(describeAggregationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations() {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsPublisher describeAggregationAuthorizationsPaginator() {
        return describeAggregationAuthorizationsPaginator(DescribeAggregationAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsPublisher describeAggregationAuthorizationsPaginator(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        return new DescribeAggregationAuthorizationsPublisher(this, describeAggregationAuthorizationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAggregationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsPublisher describeAggregationAuthorizationsPaginator(
            Consumer<DescribeAggregationAuthorizationsRequest.Builder> describeAggregationAuthorizationsRequest) {
        return describeAggregationAuthorizationsPaginator(DescribeAggregationAuthorizationsRequest.builder()
                .applyMutation(describeAggregationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this operation returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this operation returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByConfigRuleRequest#builder()}
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            Consumer<DescribeComplianceByConfigRuleRequest.Builder> describeComplianceByConfigRuleRequest) {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder()
                .applyMutation(describeComplianceByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this operation returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule() {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRulePublisher describeComplianceByConfigRulePaginator() {
        return describeComplianceByConfigRulePaginator(DescribeComplianceByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRulePublisher describeComplianceByConfigRulePaginator(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        return new DescribeComplianceByConfigRulePublisher(this, describeComplianceByConfigRuleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByConfigRuleRequest#builder()}
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRulePublisher describeComplianceByConfigRulePaginator(
            Consumer<DescribeComplianceByConfigRuleRequest.Builder> describeComplianceByConfigRuleRequest) {
        return describeComplianceByConfigRulePaginator(DescribeComplianceByConfigRuleRequest.builder()
                .applyMutation(describeComplianceByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * operation returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * operation returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByResourceRequest#builder()}
     * </p>
     *
     * @param describeComplianceByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            Consumer<DescribeComplianceByResourceRequest.Builder> describeComplianceByResourceRequest) {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder()
                .applyMutation(describeComplianceByResourceRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * operation returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource() {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourcePublisher describeComplianceByResourcePaginator() {
        return describeComplianceByResourcePaginator(DescribeComplianceByResourceRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourcePublisher describeComplianceByResourcePaginator(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        return new DescribeComplianceByResourcePublisher(this, describeComplianceByResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByResourceRequest#builder()}
     * </p>
     *
     * @param describeComplianceByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourcePublisher describeComplianceByResourcePaginator(
            Consumer<DescribeComplianceByResourceRequest.Builder> describeComplianceByResourceRequest) {
        return describeComplianceByResourcePaginator(DescribeComplianceByResourceRequest.builder()
                .applyMutation(describeComplianceByResourceRequest).build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRuleEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigRuleEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            Consumer<DescribeConfigRuleEvaluationStatusRequest.Builder> describeConfigRuleEvaluationStatusRequest) {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder()
                .applyMutation(describeConfigRuleEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus() {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusPublisher describeConfigRuleEvaluationStatusPaginator() {
        return describeConfigRuleEvaluationStatusPaginator(DescribeConfigRuleEvaluationStatusRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusPublisher describeConfigRuleEvaluationStatusPaginator(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        return new DescribeConfigRuleEvaluationStatusPublisher(this, describeConfigRuleEvaluationStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRuleEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigRuleEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusPublisher describeConfigRuleEvaluationStatusPaginator(
            Consumer<DescribeConfigRuleEvaluationStatusRequest.Builder> describeConfigRuleEvaluationStatusRequest) {
        return describeConfigRuleEvaluationStatusPaginator(DescribeConfigRuleEvaluationStatusRequest.builder()
                .applyMutation(describeConfigRuleEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            DescribeConfigRulesRequest describeConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRulesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            Consumer<DescribeConfigRulesRequest.Builder> describeConfigRulesRequest) {
        return describeConfigRules(DescribeConfigRulesRequest.builder().applyMutation(describeConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules() {
        return describeConfigRules(DescribeConfigRulesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesPublisher describeConfigRulesPaginator() {
        return describeConfigRulesPaginator(DescribeConfigRulesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesPublisher describeConfigRulesPaginator(DescribeConfigRulesRequest describeConfigRulesRequest) {
        return new DescribeConfigRulesPublisher(this, describeConfigRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRulesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesPublisher describeConfigRulesPaginator(
            Consumer<DescribeConfigRulesRequest.Builder> describeConfigRulesRequest) {
        return describeConfigRulesPaginator(DescribeConfigRulesRequest.builder().applyMutation(describeConfigRulesRequest)
                .build());
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            Consumer<DescribeConfigurationAggregatorSourcesStatusRequest.Builder> describeConfigurationAggregatorSourcesStatusRequest) {
        return describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest.builder()
                .applyMutation(describeConfigurationAggregatorSourcesStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusPublisher describeConfigurationAggregatorSourcesStatusPaginator(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        return new DescribeConfigurationAggregatorSourcesStatusPublisher(this,
                describeConfigurationAggregatorSourcesStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusPublisher describeConfigurationAggregatorSourcesStatusPaginator(
            Consumer<DescribeConfigurationAggregatorSourcesStatusRequest.Builder> describeConfigurationAggregatorSourcesStatusRequest) {
        return describeConfigurationAggregatorSourcesStatusPaginator(DescribeConfigurationAggregatorSourcesStatusRequest
                .builder().applyMutation(describeConfigurationAggregatorSourcesStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this operation returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this operation returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationAggregatorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationAggregatorsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            Consumer<DescribeConfigurationAggregatorsRequest.Builder> describeConfigurationAggregatorsRequest) {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder()
                .applyMutation(describeConfigurationAggregatorsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this operation returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators() {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsPublisher describeConfigurationAggregatorsPaginator() {
        return describeConfigurationAggregatorsPaginator(DescribeConfigurationAggregatorsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsPublisher describeConfigurationAggregatorsPaginator(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        return new DescribeConfigurationAggregatorsPublisher(this, describeConfigurationAggregatorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationAggregatorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationAggregatorsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsPublisher describeConfigurationAggregatorsPaginator(
            Consumer<DescribeConfigurationAggregatorsRequest.Builder> describeConfigurationAggregatorsRequest) {
        return describeConfigurationAggregatorsPaginator(DescribeConfigurationAggregatorsRequest.builder()
                .applyMutation(describeConfigurationAggregatorsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the configuration recorder you specify as well as the status of the last recording
     * event for the configuration recorders.
     * </p>
     * <p>
     * For a detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns the status for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the configuration recorder you specify as well as the status of the last recording
     * event for the configuration recorders.
     * </p>
     * <p>
     * For a detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns the status for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecorderStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecorderStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            Consumer<DescribeConfigurationRecorderStatusRequest.Builder> describeConfigurationRecorderStatusRequest) {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder()
                .applyMutation(describeConfigurationRecorderStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the configuration recorder you specify as well as the status of the last recording
     * event for the configuration recorders.
     * </p>
     * <p>
     * For a detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns the status for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus() {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns details for the configuration recorder you specify.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns details for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for the configuration recorder you specify.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns details for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecordersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecordersRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecordersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            Consumer<DescribeConfigurationRecordersRequest.Builder> describeConfigurationRecordersRequest) {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder()
                .applyMutation(describeConfigurationRecordersRequest).build());
    }

    /**
     * <p>
     * Returns details for the configuration recorder you specify.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns details for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders() {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackComplianceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackComplianceRequest#builder()}
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            Consumer<DescribeConformancePackComplianceRequest.Builder> describeConformancePackComplianceRequest) {
        return describeConformancePackCompliance(DescribeConformancePackComplianceRequest.builder()
                .applyMutation(describeConformancePackComplianceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackCompliancePublisher describeConformancePackCompliancePaginator(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        return new DescribeConformancePackCompliancePublisher(this, describeConformancePackComplianceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackComplianceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackComplianceRequest#builder()}
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackCompliancePublisher describeConformancePackCompliancePaginator(
            Consumer<DescribeConformancePackComplianceRequest.Builder> describeConformancePackComplianceRequest) {
        return describeConformancePackCompliancePaginator(DescribeConformancePackComplianceRequest.builder()
                .applyMutation(describeConformancePackComplianceRequest).build());
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackStatusRequest#builder()}
     * </p>
     *
     * @param describeConformancePackStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            Consumer<DescribeConformancePackStatusRequest.Builder> describeConformancePackStatusRequest) {
        return describeConformancePackStatus(DescribeConformancePackStatusRequest.builder()
                .applyMutation(describeConformancePackStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusPublisher describeConformancePackStatusPaginator(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        return new DescribeConformancePackStatusPublisher(this, describeConformancePackStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackStatusRequest#builder()}
     * </p>
     *
     * @param describeConformancePackStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusPublisher describeConformancePackStatusPaginator(
            Consumer<DescribeConformancePackStatusRequest.Builder> describeConformancePackStatusRequest) {
        return describeConformancePackStatusPaginator(DescribeConformancePackStatusRequest.builder()
                .applyMutation(describeConformancePackStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePacksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            Consumer<DescribeConformancePacksRequest.Builder> describeConformancePacksRequest) {
        return describeConformancePacks(DescribeConformancePacksRequest.builder().applyMutation(describeConformancePacksRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksPublisher describeConformancePacksPaginator(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        return new DescribeConformancePacksPublisher(this, describeConformancePacksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePacksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksPublisher describeConformancePacksPaginator(
            Consumer<DescribeConformancePacksRequest.Builder> describeConformancePacksRequest) {
        return describeConformancePacksPaginator(DescribeConformancePacksRequest.builder()
                .applyMutation(describeConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this
     * operation returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this
     * operation returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDeliveryChannelStatusRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest.Builder} to
     *        create a request. The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            Consumer<DescribeDeliveryChannelStatusRequest.Builder> describeDeliveryChannelStatusRequest) {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder()
                .applyMutation(describeDeliveryChannelStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this
     * operation returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus() {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this operation
     * returns the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this operation
     * returns the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeliveryChannelsRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest.Builder} to create a
     *        request. The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            Consumer<DescribeDeliveryChannelsRequest.Builder> describeDeliveryChannelsRequest) {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().applyMutation(describeDeliveryChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this operation
     * returns the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels() {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().build());
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConfigRuleStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConfigRuleStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            Consumer<DescribeOrganizationConfigRuleStatusesRequest.Builder> describeOrganizationConfigRuleStatusesRequest) {
        return describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesRequest.builder()
                .applyMutation(describeOrganizationConfigRuleStatusesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesPublisher describeOrganizationConfigRuleStatusesPaginator(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        return new DescribeOrganizationConfigRuleStatusesPublisher(this, describeOrganizationConfigRuleStatusesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConfigRuleStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConfigRuleStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesPublisher describeOrganizationConfigRuleStatusesPaginator(
            Consumer<DescribeOrganizationConfigRuleStatusesRequest.Builder> describeOrganizationConfigRuleStatusesRequest) {
        return describeOrganizationConfigRuleStatusesPaginator(DescribeOrganizationConfigRuleStatusesRequest.builder()
                .applyMutation(describeOrganizationConfigRuleStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            Consumer<DescribeOrganizationConfigRulesRequest.Builder> describeOrganizationConfigRulesRequest) {
        return describeOrganizationConfigRules(DescribeOrganizationConfigRulesRequest.builder()
                .applyMutation(describeOrganizationConfigRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesPublisher describeOrganizationConfigRulesPaginator(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        return new DescribeOrganizationConfigRulesPublisher(this, describeOrganizationConfigRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesPublisher describeOrganizationConfigRulesPaginator(
            Consumer<DescribeOrganizationConfigRulesRequest.Builder> describeOrganizationConfigRulesRequest) {
        return describeOrganizationConfigRulesPaginator(DescribeOrganizationConfigRulesRequest.builder()
                .applyMutation(describeOrganizationConfigRulesRequest).build());
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePackStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePackStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            Consumer<DescribeOrganizationConformancePackStatusesRequest.Builder> describeOrganizationConformancePackStatusesRequest) {
        return describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesRequest.builder()
                .applyMutation(describeOrganizationConformancePackStatusesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesPublisher describeOrganizationConformancePackStatusesPaginator(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        return new DescribeOrganizationConformancePackStatusesPublisher(this, describeOrganizationConformancePackStatusesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePackStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePackStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesPublisher describeOrganizationConformancePackStatusesPaginator(
            Consumer<DescribeOrganizationConformancePackStatusesRequest.Builder> describeOrganizationConformancePackStatusesRequest) {
        return describeOrganizationConformancePackStatusesPaginator(DescribeOrganizationConformancePackStatusesRequest.builder()
                .applyMutation(describeOrganizationConformancePackStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            Consumer<DescribeOrganizationConformancePacksRequest.Builder> describeOrganizationConformancePacksRequest) {
        return describeOrganizationConformancePacks(DescribeOrganizationConformancePacksRequest.builder()
                .applyMutation(describeOrganizationConformancePacksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksPublisher describeOrganizationConformancePacksPaginator(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        return new DescribeOrganizationConformancePacksPublisher(this, describeOrganizationConformancePacksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksPublisher describeOrganizationConformancePacksPaginator(
            Consumer<DescribeOrganizationConformancePacksRequest.Builder> describeOrganizationConformancePacksRequest) {
        return describeOrganizationConformancePacksPaginator(DescribeOrganizationConformancePacksRequest.builder()
                .applyMutation(describeOrganizationConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingAggregationRequestsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingAggregationRequestsRequest#builder()}
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(
            Consumer<DescribePendingAggregationRequestsRequest.Builder> describePendingAggregationRequestsRequest) {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder()
                .applyMutation(describePendingAggregationRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests() {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsPublisher describePendingAggregationRequestsPaginator() {
        return describePendingAggregationRequestsPaginator(DescribePendingAggregationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsPublisher describePendingAggregationRequestsPaginator(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        return new DescribePendingAggregationRequestsPublisher(this, describePendingAggregationRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingAggregationRequestsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingAggregationRequestsRequest#builder()}
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsPublisher describePendingAggregationRequestsPaginator(
            Consumer<DescribePendingAggregationRequestsRequest.Builder> describePendingAggregationRequestsRequest) {
        return describePendingAggregationRequestsPaginator(DescribePendingAggregationRequestsRequest.builder()
                .applyMutation(describePendingAggregationRequestsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(
            DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(
            Consumer<DescribeRemediationConfigurationsRequest.Builder> describeRemediationConfigurationsRequest) {
        return describeRemediationConfigurations(DescribeRemediationConfigurationsRequest.builder()
                .applyMutation(describeRemediationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note>
     *
     * @param describeRemediationExceptionsRequest
     * @return A Java Future containing the result of the DescribeRemediationExceptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationExceptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest) {
        return describeRemediationExceptions(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsPublisher describeRemediationExceptionsPaginator(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        return new DescribeRemediationExceptionsPublisher(this, describeRemediationExceptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsPublisher describeRemediationExceptionsPaginator(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest) {
        return describeRemediationExceptionsPaginator(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A Java Future containing the result of the DescribeRemediationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest) {
        return describeRemediationExecutionStatus(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusPublisher describeRemediationExecutionStatusPaginator(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        return new DescribeRemediationExecutionStatusPublisher(this, describeRemediationExecutionStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusPublisher describeRemediationExecutionStatusPaginator(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest) {
        return describeRemediationExecutionStatusPaginator(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this operation returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this operation returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetentionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetentionConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(
            Consumer<DescribeRetentionConfigurationsRequest.Builder> describeRetentionConfigurationsRequest) {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder()
                .applyMutation(describeRetentionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this operation returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations() {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsPublisher describeRetentionConfigurationsPaginator() {
        return describeRetentionConfigurationsPaginator(DescribeRetentionConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsPublisher describeRetentionConfigurationsPaginator(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        return new DescribeRetentionConfigurationsPublisher(this, describeRetentionConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetentionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetentionConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsPublisher describeRetentionConfigurationsPaginator(
            Consumer<DescribeRetentionConfigurationsRequest.Builder> describeRetentionConfigurationsRequest) {
        return describeRetentionConfigurationsPaginator(DescribeRetentionConfigurationsRequest.builder()
                .applyMutation(describeRetentionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Removes all resource types specified in the <code>ResourceTypes</code> list from the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> of
     * configuration recorder and excludes these resource types when recording.
     * </p>
     * <p>
     * For this operation, the configuration recorder must use a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a>
     * that is either <code>INCLUSION_BY_RESOURCE_TYPES</code> or <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     * </p>
     *
     * @param disassociateResourceTypesRequest
     * @return A Java Future containing the result of the DisassociateResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DisassociateResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DisassociateResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceTypesResponse> disassociateResourceTypes(
            DisassociateResourceTypesRequest disassociateResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all resource types specified in the <code>ResourceTypes</code> list from the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> of
     * configuration recorder and excludes these resource types when recording.
     * </p>
     * <p>
     * For this operation, the configuration recorder must use a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a>
     * that is either <code>INCLUSION_BY_RESOURCE_TYPES</code> or <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResourceTypesRequest#builder()}
     * </p>
     *
     * @param disassociateResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DisassociateResourceTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DisassociateResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DisassociateResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceTypesResponse> disassociateResourceTypes(
            Consumer<DisassociateResourceTypesRequest.Builder> disassociateResourceTypesRequest) {
        return disassociateResourceTypes(DisassociateResourceTypesRequest.builder()
                .applyMutation(disassociateResourceTypesRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetAggregateComplianceDetailsByConfigRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAggregateComplianceDetailsByConfigRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(
            Consumer<GetAggregateComplianceDetailsByConfigRuleRequest.Builder> getAggregateComplianceDetailsByConfigRuleRequest) {
        return getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getAggregateComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRulePublisher getAggregateComplianceDetailsByConfigRulePaginator(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        return new GetAggregateComplianceDetailsByConfigRulePublisher(this, getAggregateComplianceDetailsByConfigRuleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRulePublisher getAggregateComplianceDetailsByConfigRulePaginator(
            Consumer<GetAggregateComplianceDetailsByConfigRuleRequest.Builder> getAggregateComplianceDetailsByConfigRuleRequest) {
        return getAggregateComplianceDetailsByConfigRulePaginator(GetAggregateComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getAggregateComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConfigRuleComplianceSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConfigRuleComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAggregateConfigRuleComplianceSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(
            Consumer<GetAggregateConfigRuleComplianceSummaryRequest.Builder> getAggregateConfigRuleComplianceSummaryRequest) {
        return getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConfigRuleComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryPublisher getAggregateConfigRuleComplianceSummaryPaginator(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        return new GetAggregateConfigRuleComplianceSummaryPublisher(this, getAggregateConfigRuleComplianceSummaryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConfigRuleComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryPublisher getAggregateConfigRuleComplianceSummaryPaginator(
            Consumer<GetAggregateConfigRuleComplianceSummaryRequest.Builder> getAggregateConfigRuleComplianceSummaryRequest) {
        return getAggregateConfigRuleComplianceSummaryPaginator(GetAggregateConfigRuleComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConfigRuleComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConformancePackComplianceSummary operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> getAggregateConformancePackComplianceSummary(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAggregateConformancePackComplianceSummary operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> getAggregateConformancePackComplianceSummary(
            Consumer<GetAggregateConformancePackComplianceSummaryRequest.Builder> getAggregateConformancePackComplianceSummaryRequest) {
        return getAggregateConformancePackComplianceSummary(GetAggregateConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryPublisher getAggregateConformancePackComplianceSummaryPaginator(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest) {
        return new GetAggregateConformancePackComplianceSummaryPublisher(this,
                getAggregateConformancePackComplianceSummaryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryPublisher getAggregateConformancePackComplianceSummaryPaginator(
            Consumer<GetAggregateConformancePackComplianceSummaryRequest.Builder> getAggregateConformancePackComplianceSummaryRequest) {
        return getAggregateConformancePackComplianceSummaryPaginator(GetAggregateConformancePackComplianceSummaryRequest
                .builder().applyMutation(getAggregateConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetAggregateDiscoveredResourceCounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateDiscoveredResourceCountsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAggregateDiscoveredResourceCounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(
            Consumer<GetAggregateDiscoveredResourceCountsRequest.Builder> getAggregateDiscoveredResourceCountsRequest) {
        return getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsRequest.builder()
                .applyMutation(getAggregateDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsPublisher getAggregateDiscoveredResourceCountsPaginator(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        return new GetAggregateDiscoveredResourceCountsPublisher(this, getAggregateDiscoveredResourceCountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateDiscoveredResourceCountsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsPublisher getAggregateDiscoveredResourceCountsPaginator(
            Consumer<GetAggregateDiscoveredResourceCountsRequest.Builder> getAggregateDiscoveredResourceCountsRequest) {
        return getAggregateDiscoveredResourceCountsPaginator(GetAggregateDiscoveredResourceCountsRequest.builder()
                .applyMutation(getAggregateDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     * <note>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </note>
     *
     * @param getAggregateResourceConfigRequest
     * @return A Java Future containing the result of the GetAggregateResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>OversizedConfigurationItemException The configuration item size is outside the allowable range.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(
            GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     * <note>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAggregateResourceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAggregateResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>OversizedConfigurationItemException The configuration item size is outside the allowable range.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(
            Consumer<GetAggregateResourceConfigRequest.Builder> getAggregateResourceConfigRequest) {
        return getAggregateResourceConfig(GetAggregateResourceConfigRequest.builder()
                .applyMutation(getAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceDetailsByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(
            Consumer<GetComplianceDetailsByConfigRuleRequest.Builder> getComplianceDetailsByConfigRuleRequest) {
        return getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRulePublisher getComplianceDetailsByConfigRulePaginator(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        return new GetComplianceDetailsByConfigRulePublisher(this, getComplianceDetailsByConfigRuleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRulePublisher getComplianceDetailsByConfigRulePaginator(
            Consumer<GetComplianceDetailsByConfigRuleRequest.Builder> getComplianceDetailsByConfigRuleRequest) {
        return getComplianceDetailsByConfigRulePaginator(GetComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByResourceRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceDetailsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(
            Consumer<GetComplianceDetailsByResourceRequest.Builder> getComplianceDetailsByResourceRequest) {
        return getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest.builder()
                .applyMutation(getComplianceDetailsByResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourcePublisher getComplianceDetailsByResourcePaginator(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        return new GetComplianceDetailsByResourcePublisher(this, getComplianceDetailsByResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByResourceRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourcePublisher getComplianceDetailsByResourcePaginator(
            Consumer<GetComplianceDetailsByResourceRequest.Builder> getComplianceDetailsByResourceRequest) {
        return getComplianceDetailsByResourcePaginator(GetComplianceDetailsByResourceRequest.builder()
                .applyMutation(getComplianceDetailsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(
            Consumer<GetComplianceSummaryByConfigRuleRequest.Builder> getComplianceSummaryByConfigRuleRequest) {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder()
                .applyMutation(getComplianceSummaryByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule() {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByResourceTypeRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByResourceTypeRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(
            Consumer<GetComplianceSummaryByResourceTypeRequest.Builder> getComplianceSummaryByResourceTypeRequest) {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder()
                .applyMutation(getComplianceSummaryByResourceTypeRequest).build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType() {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceDetailsResponse> getConformancePackComplianceDetails(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceDetailsRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConformancePackComplianceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceDetailsResponse> getConformancePackComplianceDetails(
            Consumer<GetConformancePackComplianceDetailsRequest.Builder> getConformancePackComplianceDetailsRequest) {
        return getConformancePackComplianceDetails(GetConformancePackComplianceDetailsRequest.builder()
                .applyMutation(getConformancePackComplianceDetailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsPublisher getConformancePackComplianceDetailsPaginator(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) {
        return new GetConformancePackComplianceDetailsPublisher(this, getConformancePackComplianceDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceDetailsRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsPublisher getConformancePackComplianceDetailsPaginator(
            Consumer<GetConformancePackComplianceDetailsRequest.Builder> getConformancePackComplianceDetailsRequest) {
        return getConformancePackComplianceDetailsPaginator(GetConformancePackComplianceDetailsRequest.builder()
                .applyMutation(getConformancePackComplianceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceSummaryResponse> getConformancePackComplianceSummary(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConformancePackComplianceSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceSummaryResponse> getConformancePackComplianceSummary(
            Consumer<GetConformancePackComplianceSummaryRequest.Builder> getConformancePackComplianceSummaryRequest) {
        return getConformancePackComplianceSummary(GetConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryPublisher getConformancePackComplianceSummaryPaginator(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest) {
        return new GetConformancePackComplianceSummaryPublisher(this, getConformancePackComplianceSummaryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryPublisher getConformancePackComplianceSummaryPaginator(
            Consumer<GetConformancePackComplianceSummaryRequest.Builder> getConformancePackComplianceSummaryRequest) {
        return getConformancePackComplianceSummaryPaginator(GetConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     *
     * @param getCustomRulePolicyRequest
     * @return A Java Future containing the result of the GetCustomRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCustomRulePolicyResponse> getCustomRulePolicy(
            GetCustomRulePolicyRequest getCustomRulePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetCustomRulePolicyRequest#builder()}
     * </p>
     *
     * @param getCustomRulePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCustomRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCustomRulePolicyResponse> getCustomRulePolicy(
            Consumer<GetCustomRulePolicyRequest.Builder> getCustomRulePolicyRequest) {
        return getCustomRulePolicy(GetCustomRulePolicyRequest.builder().applyMutation(getCustomRulePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredResourceCountsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(
            Consumer<GetDiscoveredResourceCountsRequest.Builder> getDiscoveredResourceCountsRequest) {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder()
                .applyMutation(getDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts() {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsPublisher getDiscoveredResourceCountsPaginator() {
        return getDiscoveredResourceCountsPaginator(GetDiscoveredResourceCountsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsPublisher getDiscoveredResourceCountsPaginator(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        return new GetDiscoveredResourceCountsPublisher(this, getDiscoveredResourceCountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredResourceCountsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsPublisher getDiscoveredResourceCountsPaginator(
            Consumer<GetDiscoveredResourceCountsRequest.Builder> getDiscoveredResourceCountsRequest) {
        return getDiscoveredResourceCountsPaginator(GetDiscoveredResourceCountsRequest.builder()
                .applyMutation(getDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConfigRuleDetailedStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> getOrganizationConfigRuleDetailedStatus(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConfigRuleDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetOrganizationConfigRuleDetailedStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> getOrganizationConfigRuleDetailedStatus(
            Consumer<GetOrganizationConfigRuleDetailedStatusRequest.Builder> getOrganizationConfigRuleDetailedStatusRequest) {
        return getOrganizationConfigRuleDetailedStatus(GetOrganizationConfigRuleDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConfigRuleDetailedStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusPublisher getOrganizationConfigRuleDetailedStatusPaginator(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest) {
        return new GetOrganizationConfigRuleDetailedStatusPublisher(this, getOrganizationConfigRuleDetailedStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConfigRuleDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusPublisher getOrganizationConfigRuleDetailedStatusPaginator(
            Consumer<GetOrganizationConfigRuleDetailedStatusRequest.Builder> getOrganizationConfigRuleDetailedStatusRequest) {
        return getOrganizationConfigRuleDetailedStatusPaginator(GetOrganizationConfigRuleDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConfigRuleDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConformancePackDetailedStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> getOrganizationConformancePackDetailedStatus(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConformancePackDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetOrganizationConformancePackDetailedStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> getOrganizationConformancePackDetailedStatus(
            Consumer<GetOrganizationConformancePackDetailedStatusRequest.Builder> getOrganizationConformancePackDetailedStatusRequest) {
        return getOrganizationConformancePackDetailedStatus(GetOrganizationConformancePackDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConformancePackDetailedStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConformancePackDetailedStatusPublisher getOrganizationConformancePackDetailedStatusPaginator(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest) {
        return new GetOrganizationConformancePackDetailedStatusPublisher(this,
                getOrganizationConformancePackDetailedStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConformancePackDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the