/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliverConfigSnapshotRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DeliverConfigSnapshotRequest> {
    private static final SdkField<String> DELIVERY_CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliverConfigSnapshotRequest.getter(DeliverConfigSnapshotRequest::deliveryChannelName)).setter(DeliverConfigSnapshotRequest.setter(Builder::deliveryChannelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryChannelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_CHANNEL_NAME_FIELD));
    private final String deliveryChannelName;

    private DeliverConfigSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelName = builder.deliveryChannelName;
    }

    public String deliveryChannelName() {
        return this.deliveryChannelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryChannelName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverConfigSnapshotRequest)) {
            return false;
        }
        DeliverConfigSnapshotRequest other = (DeliverConfigSnapshotRequest)((Object)obj);
        return Objects.equals(this.deliveryChannelName(), other.deliveryChannelName());
    }

    public String toString() {
        return ToString.builder((String)"DeliverConfigSnapshotRequest").add("DeliveryChannelName", (Object)this.deliveryChannelName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryChannelName": {
                return Optional.ofNullable(clazz.cast(this.deliveryChannelName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliverConfigSnapshotRequest, T> g) {
        return obj -> g.apply((DeliverConfigSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String deliveryChannelName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverConfigSnapshotRequest model) {
            super(model);
            this.deliveryChannelName(model.deliveryChannelName);
        }

        public final String getDeliveryChannelName() {
            return this.deliveryChannelName;
        }

        @Override
        public final Builder deliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
            return this;
        }

        public final void setDeliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeliverConfigSnapshotRequest build() {
            return new DeliverConfigSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeliverConfigSnapshotRequest> {
        public Builder deliveryChannelName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

