/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.DeliveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigExportDeliveryInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigExportDeliveryInfo> {
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::lastStatusAsString)).setter(ConfigExportDeliveryInfo.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorCode").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::lastErrorCode)).setter(ConfigExportDeliveryInfo.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorMessage").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::lastErrorMessage)).setter(ConfigExportDeliveryInfo.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_ATTEMPT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAttemptTime").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::lastAttemptTime)).setter(ConfigExportDeliveryInfo.setter(Builder::lastAttemptTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptTime").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSuccessfulTime").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::lastSuccessfulTime)).setter(ConfigExportDeliveryInfo.setter(Builder::lastSuccessfulTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulTime").build()}).build();
    private static final SdkField<Instant> NEXT_DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("nextDeliveryTime").getter(ConfigExportDeliveryInfo.getter(ConfigExportDeliveryInfo::nextDeliveryTime)).setter(ConfigExportDeliveryInfo.setter(Builder::nextDeliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextDeliveryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_ATTEMPT_TIME_FIELD, LAST_SUCCESSFUL_TIME_FIELD, NEXT_DELIVERY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigExportDeliveryInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastAttemptTime;
    private final Instant lastSuccessfulTime;
    private final Instant nextDeliveryTime;

    private ConfigExportDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastAttemptTime = builder.lastAttemptTime;
        this.lastSuccessfulTime = builder.lastSuccessfulTime;
        this.nextDeliveryTime = builder.nextDeliveryTime;
    }

    public final DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(this.lastStatus);
    }

    public final String lastStatusAsString() {
        return this.lastStatus;
    }

    public final String lastErrorCode() {
        return this.lastErrorCode;
    }

    public final String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public final Instant lastAttemptTime() {
        return this.lastAttemptTime;
    }

    public final Instant lastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public final Instant nextDeliveryTime() {
        return this.nextDeliveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextDeliveryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigExportDeliveryInfo)) {
            return false;
        }
        ConfigExportDeliveryInfo other = (ConfigExportDeliveryInfo)obj;
        return Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastAttemptTime(), other.lastAttemptTime()) && Objects.equals(this.lastSuccessfulTime(), other.lastSuccessfulTime()) && Objects.equals(this.nextDeliveryTime(), other.nextDeliveryTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigExportDeliveryInfo").add("LastStatus", (Object)this.lastStatusAsString()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("LastAttemptTime", (Object)this.lastAttemptTime()).add("LastSuccessfulTime", (Object)this.lastSuccessfulTime()).add("NextDeliveryTime", (Object)this.nextDeliveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "lastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "lastAttemptTime": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptTime()));
            }
            case "lastSuccessfulTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulTime()));
            }
            case "nextDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.nextDeliveryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lastStatus", LAST_STATUS_FIELD);
        map.put("lastErrorCode", LAST_ERROR_CODE_FIELD);
        map.put("lastErrorMessage", LAST_ERROR_MESSAGE_FIELD);
        map.put("lastAttemptTime", LAST_ATTEMPT_TIME_FIELD);
        map.put("lastSuccessfulTime", LAST_SUCCESSFUL_TIME_FIELD);
        map.put("nextDeliveryTime", NEXT_DELIVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigExportDeliveryInfo, T> g) {
        return obj -> g.apply((ConfigExportDeliveryInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastAttemptTime;
        private Instant lastSuccessfulTime;
        private Instant nextDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigExportDeliveryInfo model) {
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastAttemptTime(model.lastAttemptTime);
            this.lastSuccessfulTime(model.lastSuccessfulTime);
            this.nextDeliveryTime(model.nextDeliveryTime);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final Instant getLastAttemptTime() {
            return this.lastAttemptTime;
        }

        public final void setLastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
        }

        @Override
        public final Builder lastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
            return this;
        }

        public final Instant getLastSuccessfulTime() {
            return this.lastSuccessfulTime;
        }

        public final void setLastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        @Override
        public final Builder lastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
            return this;
        }

        public final Instant getNextDeliveryTime() {
            return this.nextDeliveryTime;
        }

        public final void setNextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
        }

        @Override
        public final Builder nextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
            return this;
        }

        public ConfigExportDeliveryInfo build() {
            return new ConfigExportDeliveryInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigExportDeliveryInfo> {
        public Builder lastStatus(String var1);

        public Builder lastStatus(DeliveryStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastAttemptTime(Instant var1);

        public Builder lastSuccessfulTime(Instant var1);

        public Builder nextDeliveryTime(Instant var1);
    }
}

