/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.RecordingFrequency;
import software.amazon.awssdk.services.config.model.RecordingModeResourceTypesListCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingModeOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingModeOverride> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RecordingModeOverride.getter(RecordingModeOverride::description)).setter(RecordingModeOverride.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(RecordingModeOverride.getter(RecordingModeOverride::resourceTypesAsStrings)).setter(RecordingModeOverride.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECORDING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingFrequency").getter(RecordingModeOverride.getter(RecordingModeOverride::recordingFrequencyAsString)).setter(RecordingModeOverride.setter(Builder::recordingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingFrequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, RESOURCE_TYPES_FIELD, RECORDING_FREQUENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("resourceTypes", RESOURCE_TYPES_FIELD);
            this.put("recordingFrequency", RECORDING_FREQUENCY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> resourceTypes;
    private final String recordingFrequency;

    private RecordingModeOverride(BuilderImpl builder) {
        this.description = builder.description;
        this.resourceTypes = builder.resourceTypes;
        this.recordingFrequency = builder.recordingFrequency;
    }

    public final String description() {
        return this.description;
    }

    public final List<ResourceType> resourceTypes() {
        return RecordingModeResourceTypesListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final RecordingFrequency recordingFrequency() {
        return RecordingFrequency.fromValue(this.recordingFrequency);
    }

    public final String recordingFrequencyAsString() {
        return this.recordingFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingFrequencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingModeOverride)) {
            return false;
        }
        RecordingModeOverride other = (RecordingModeOverride)obj;
        return Objects.equals(this.description(), other.description()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.recordingFrequencyAsString(), other.recordingFrequencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingModeOverride").add("Description", (Object)this.description()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("RecordingFrequency", (Object)this.recordingFrequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "recordingFrequency": {
                return Optional.ofNullable(clazz.cast(this.recordingFrequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecordingModeOverride, T> g) {
        return obj -> g.apply((RecordingModeOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String recordingFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingModeOverride model) {
            this.description(model.description);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.recordingFrequency(model.recordingFrequency);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = RecordingModeResourceTypesListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = RecordingModeResourceTypesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = RecordingModeResourceTypesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getRecordingFrequency() {
            return this.recordingFrequency;
        }

        public final void setRecordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
        }

        @Override
        public final Builder recordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
            return this;
        }

        @Override
        public final Builder recordingFrequency(RecordingFrequency recordingFrequency) {
            this.recordingFrequency(recordingFrequency == null ? null : recordingFrequency.toString());
            return this;
        }

        public RecordingModeOverride build() {
            return new RecordingModeOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingModeOverride> {
        public Builder description(String var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder recordingFrequency(String var1);

        public Builder recordingFrequency(RecordingFrequency var1);
    }
}

