/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRemediationExecutionStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeRemediationExecutionStatusRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(DescribeRemediationExecutionStatusRequest.getter(DescribeRemediationExecutionStatusRequest::configRuleName)).setter(DescribeRemediationExecutionStatusRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceKeys").getter(DescribeRemediationExecutionStatusRequest.getter(DescribeRemediationExecutionStatusRequest::resourceKeys)).setter(DescribeRemediationExecutionStatusRequest.setter(Builder::resourceKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeRemediationExecutionStatusRequest.getter(DescribeRemediationExecutionStatusRequest::limit)).setter(DescribeRemediationExecutionStatusRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRemediationExecutionStatusRequest.getter(DescribeRemediationExecutionStatusRequest::nextToken)).setter(DescribeRemediationExecutionStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, RESOURCE_KEYS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigRuleName", CONFIG_RULE_NAME_FIELD);
            this.put("ResourceKeys", RESOURCE_KEYS_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String configRuleName;
    private final List<ResourceKey> resourceKeys;
    private final Integer limit;
    private final String nextToken;

    private DescribeRemediationExecutionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final boolean hasResourceKeys() {
        return this.resourceKeys != null && !(this.resourceKeys instanceof SdkAutoConstructList);
    }

    public final List<ResourceKey> resourceKeys() {
        return this.resourceKeys;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceKeys() ? this.resourceKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExecutionStatusRequest)) {
            return false;
        }
        DescribeRemediationExecutionStatusRequest other = (DescribeRemediationExecutionStatusRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && this.hasResourceKeys() == other.hasResourceKeys() && Objects.equals(this.resourceKeys(), other.resourceKeys()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRemediationExecutionStatusRequest").add("ConfigRuleName", (Object)this.configRuleName()).add("ResourceKeys", this.hasResourceKeys() ? this.resourceKeys() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ResourceKeys": {
                return Optional.ofNullable(clazz.cast(this.resourceKeys()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExecutionStatusRequest, T> g) {
        return obj -> g.apply((DescribeRemediationExecutionStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExecutionStatusRequest model) {
            super(model);
            this.configRuleName(model.configRuleName);
            this.resourceKeys(model.resourceKeys);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final List<ResourceKey.Builder> getResourceKeys() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.resourceKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey ... resourceKeys) {
            this.resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder> ... resourceKeys) {
            this.resourceKeys(Stream.of(resourceKeys).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRemediationExecutionStatusRequest build() {
            return new DescribeRemediationExecutionStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRemediationExecutionStatusRequest> {
        public Builder configRuleName(String var1);

        public Builder resourceKeys(Collection<ResourceKey> var1);

        public Builder resourceKeys(ResourceKey ... var1);

        public Builder resourceKeys(Consumer<ResourceKey.Builder> ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

