/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.services.config.model.AggregationAuthorizationListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAggregationAuthorizationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeAggregationAuthorizationsResponse> {
    private static final SdkField<List<AggregationAuthorization>> AGGREGATION_AUTHORIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregationAuthorizations").getter(DescribeAggregationAuthorizationsResponse.getter(DescribeAggregationAuthorizationsResponse::aggregationAuthorizations)).setter(DescribeAggregationAuthorizationsResponse.setter(Builder::aggregationAuthorizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationAuthorizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationAuthorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAggregationAuthorizationsResponse.getter(DescribeAggregationAuthorizationsResponse::nextToken)).setter(DescribeAggregationAuthorizationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_AUTHORIZATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAggregationAuthorizationsResponse.memberNameToFieldInitializer();
    private final List<AggregationAuthorization> aggregationAuthorizations;
    private final String nextToken;

    private DescribeAggregationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationAuthorizations = builder.aggregationAuthorizations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAggregationAuthorizations() {
        return this.aggregationAuthorizations != null && !(this.aggregationAuthorizations instanceof SdkAutoConstructList);
    }

    public final List<AggregationAuthorization> aggregationAuthorizations() {
        return this.aggregationAuthorizations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationAuthorizations() ? this.aggregationAuthorizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregationAuthorizationsResponse)) {
            return false;
        }
        DescribeAggregationAuthorizationsResponse other = (DescribeAggregationAuthorizationsResponse)((Object)obj);
        return this.hasAggregationAuthorizations() == other.hasAggregationAuthorizations() && Objects.equals(this.aggregationAuthorizations(), other.aggregationAuthorizations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAggregationAuthorizationsResponse").add("AggregationAuthorizations", this.hasAggregationAuthorizations() ? this.aggregationAuthorizations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationAuthorizations": {
                return Optional.ofNullable(clazz.cast(this.aggregationAuthorizations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AggregationAuthorizations", AGGREGATION_AUTHORIZATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAggregationAuthorizationsResponse, T> g) {
        return obj -> g.apply((DescribeAggregationAuthorizationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregationAuthorization> aggregationAuthorizations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregationAuthorizationsResponse model) {
            super(model);
            this.aggregationAuthorizations(model.aggregationAuthorizations);
            this.nextToken(model.nextToken);
        }

        public final List<AggregationAuthorization.Builder> getAggregationAuthorizations() {
            List<AggregationAuthorization.Builder> result = AggregationAuthorizationListCopier.copyToBuilder(this.aggregationAuthorizations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationAuthorizations(Collection<AggregationAuthorization.BuilderImpl> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copyFromBuilder(aggregationAuthorizations);
        }

        @Override
        public final Builder aggregationAuthorizations(Collection<AggregationAuthorization> aggregationAuthorizations) {
            this.aggregationAuthorizations = AggregationAuthorizationListCopier.copy(aggregationAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(AggregationAuthorization ... aggregationAuthorizations) {
            this.aggregationAuthorizations(Arrays.asList(aggregationAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder> ... aggregationAuthorizations) {
            this.aggregationAuthorizations(Stream.of(aggregationAuthorizations).map(c -> (AggregationAuthorization)((AggregationAuthorization.Builder)AggregationAuthorization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAggregationAuthorizationsResponse build() {
            return new DescribeAggregationAuthorizationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAggregationAuthorizationsResponse> {
        public Builder aggregationAuthorizations(Collection<AggregationAuthorization> var1);

        public Builder aggregationAuthorizations(AggregationAuthorization ... var1);

        public Builder aggregationAuthorizations(Consumer<AggregationAuthorization.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

