/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConformancePackStatusesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
    private static final SdkField<List<OrganizationConformancePackStatus>> ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConformancePackStatuses").getter(DescribeOrganizationConformancePackStatusesResponse.getter(DescribeOrganizationConformancePackStatusesResponse::organizationConformancePackStatuses)).setter(DescribeOrganizationConformancePackStatusesResponse.setter(Builder::organizationConformancePackStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConformancePackStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConformancePackStatusesResponse.getter(DescribeOrganizationConformancePackStatusesResponse::nextToken)).setter(DescribeOrganizationConformancePackStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationConformancePackStatuses", ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<OrganizationConformancePackStatus> organizationConformancePackStatuses;
    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackStatuses = builder.organizationConformancePackStatuses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationConformancePackStatuses() {
        return this.organizationConformancePackStatuses != null && !(this.organizationConformancePackStatuses instanceof SdkAutoConstructList);
    }

    public final List<OrganizationConformancePackStatus> organizationConformancePackStatuses() {
        return this.organizationConformancePackStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConformancePackStatuses() ? this.organizationConformancePackStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesResponse other = (DescribeOrganizationConformancePackStatusesResponse)((Object)obj);
        return this.hasOrganizationConformancePackStatuses() == other.hasOrganizationConformancePackStatuses() && Objects.equals(this.organizationConformancePackStatuses(), other.organizationConformancePackStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConformancePackStatusesResponse").add("OrganizationConformancePackStatuses", this.hasOrganizationConformancePackStatuses() ? this.organizationConformancePackStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackStatuses": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConformancePackStatus> organizationConformancePackStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesResponse model) {
            super(model);
            this.organizationConformancePackStatuses(model.organizationConformancePackStatuses);
            this.nextToken(model.nextToken);
        }

        public final List<OrganizationConformancePackStatus.Builder> getOrganizationConformancePackStatuses() {
            List<OrganizationConformancePackStatus.Builder> result = OrganizationConformancePackStatusesCopier.copyToBuilder(this.organizationConformancePackStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationConformancePackStatuses(Collection<OrganizationConformancePackStatus.BuilderImpl> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier.copyFromBuilder(organizationConformancePackStatuses);
        }

        @Override
        public final Builder organizationConformancePackStatuses(Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier.copy(organizationConformancePackStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(OrganizationConformancePackStatus ... organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses(Arrays.asList(organizationConformancePackStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(Consumer<OrganizationConformancePackStatus.Builder> ... organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses(Stream.of(organizationConformancePackStatuses).map(c -> (OrganizationConformancePackStatus)((OrganizationConformancePackStatus.Builder)OrganizationConformancePackStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesResponse build() {
            return new DescribeOrganizationConformancePackStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
        public Builder organizationConformancePackStatuses(Collection<OrganizationConformancePackStatus> var1);

        public Builder organizationConformancePackStatuses(OrganizationConformancePackStatus ... var1);

        public Builder organizationConformancePackStatuses(Consumer<OrganizationConformancePackStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

